--------------------------------------
-----  Basic Chinese descriptions  ---
--------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "zh_cn"

---------- Collectibles ----------

local repCollectibles={
	[2] = {"2", "内眼", "↓ {{Tears}} 射速修正x0.51#角色一次发射3颗泪弹"}, -- The Inner Eye
	[5] = {"5", "我的镜像", "↑ {{Damage}} 伤害+1.5↑ {{Range}} 射程+1.5#↑ {{Range}} 射程修正x2#↑ {{Shotspeed}} 弹速修正x1.6#↓ {{Luck}} 幸运-1#泪弹具有回旋效果"}, -- My Reflection
	[6] = {"6", "小号", "↑ {{Tears}} 射速+1.5#↓ {{Range}} 射程-1.5#↓ {{Range}} 射程修正x0.8"}, -- Number One
	[12] = {"12", "魔法蘑菇", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.3#↑ {{Damage}} 伤害+0.3#↑ {{Damage}} 伤害修正x1.5#↑ {{Range}} 射程+2.5#体型变大#{{HealingRed}} 回满血"}, -- Magic Mushroom
	[13] = {"13", "病毒", "↑ {{Speed}} 移速+0.2#{{Poison}} 接触敌人使其中毒#角色每秒造成48点接触伤害"}, -- The Virus
	[14] = {"14", "过量类固醇", "↑ {{Speed}} 移速+0.3#↑ {{Range}} 射程+2.5"}, -- Roid Rage
	[18] = {"18", "一美元", "{{Coin}} +100硬币"}, -- A Dollar
	[22] = {"22", "午餐", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心"}, -- Lunch
	[23] = {"23", "正餐", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心"}, -- Dinner
	[24] = {"24", "甜点", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心"}, -- Dessert
	[25] = {"25", "早餐", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心"}, -- Breakfast
	[26] = {"26", "烂肉", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心"}, -- Rotten Meat
	[29] = {"29", "妈妈的内裤", "↑ {{Range}} 射程+2.5#生成3-6只蓝苍蝇"}, -- Moms Underwear
	[30] = {"30", "妈妈的高跟鞋", "↑ {{Range}} 射程+2.5#角色造成12点接触伤害"}, -- Mom's Heels
	[31] = {"31", "妈妈的口红", "↑ {{Range}} 射程+3.75#{{UnknownHeart}} 生成1随机心"}, -- Mom's Lipstick
	[37] = {"37", "炸弹先生", "在角色下方放置1大炸弹, 造成185点伤害"}, -- Mr. Boom
	[40] = {"40", "神风！", "在角色位置造成一次爆炸#造成40点伤害"}, -- Kamikaze!
	[41] = {"41", "妈妈的卫生巾", "{{Fear}} 使房间中所有敌人恐惧5秒#生成1只蓝苍蝇"},
	[42] = {"42", "鲍勃的烂头", "向发射方向投掷头#{{Poison}} 头接触到敌人时爆炸并产生毒气#造成1x角色伤害+185的伤害"}, -- Bob's Rotten Head
	[46] = {"46", "幸运脚", "↑ {{Luck}} 幸运+1#提升房间清理奖励概率#赌博时赢的概率更高#将一些坏胶囊变成好胶囊"}, -- Lucky Foot
	[49] = {"49", "嗖-哒-呜！", "下一次发射由激光取代#在0.83秒内造成24x角色伤害"}, -- Shoop da Whoop!
	[52] = {"52", "胎儿博士", "↓ {{Tears}} 射速修正x0.4#{{Bomb}} 角色的泪弹由炸弹取代#{{Damage}} 该炸弹造成10x角色伤害#若结果超过60, 则改为5x+30"}, --Dr. Fetus
	[53] = {"53", "万磁王", "角色吸引掉落物#自动打开2格远的箱子, 忽略刺箱伤害"}, -- Magneto
	[55] = {"55", "妈妈的眼睛", "50%概率向后发射1颗泪弹#{{Luck}} 幸运5: 100%概率"}, -- Mom's Eye
	[59] = {"59", "彼列之书", "{{AngelDevilChance}} 持有时, 恶魔房/天使房概率+12.5%#{{Timer}} 使用后, 在当前房间中获得:#↑ {{Damage}} 伤害+2"}, -- The Book of Belial (Judas's Birthright Version)
	[62] = {"62", "吸血鬼之魅", "↑ {{Damage}} 伤害+0.3#{{HealingRed}} 每击杀13个敌人治疗半红心"}, -- Charm of the Vampire
	[67] = {"67", "玛姬姐妹", "发射普通泪弹#泪弹造成6点伤害"}, -- Sister Maggy
	[69] = {"69", "巧克力牛奶", "{{Chargeable}} 可蓄力泪弹#{{Damage}} 伤害随蓄力时间提升, 最高4x"}, -- Chocolate Milk
	[70] = {"70", "生长激素", "↑ {{Speed}} 移速+0.2#↑ {{Damage}} 伤害+1"}, -- Growth Hormones
	[71] = {"71", "小蘑菇", "↑ {{Speed}} 移速+0.3#↑ {{Range}} 射程+2.5#↑ 体型变小"}, -- Mini Mush
	[72] = {"72", "念珠", "↑ {{Tears}} 射速+0.5#{{SoulHeart}} +3魂心#{{Collectible33}} 圣经添加至所有道具池"}, -- Rosary
	[78] = {"78", "启示录", "{{SoulHeart}} +1魂心#{{AngelDevilChance}} 持有时, 恶魔房/天使房概率+17.5%#使用后, 本层头目由天启骑士取代"}, -- Book of Revelations
	[79] = {"79", "咒印", "↑ {{Speed}} 移速+0.2#↑ {{Damage}} 伤害+1#{{BlackHeart}} +1黑心"}, -- The Mark
	[80] = {"80", "契约", "↑ {{Tears}} 射速+0.7#↑ {{Damage}} 伤害+0.5#{{BlackHeart}} +2黑心"}, -- The Pact
	[83] = {"83", "钉子", "使用后:#{{HalfBlackHeart}} +半黑心#{{Timer}} 在当前房间中获得:#↑ {{Damage}} 伤害+2#↓ {{Speed}} 移速-0.18#角色每秒造成40点接触伤害#角色可粉碎接触的石头"}, -- The Nail
	[84] = {"84", "我们需要深入挖掘！", "打开1个跳过本层的活板门#{{LadderRoom}} 在有装饰(草/碎石/纸/宝石等)的地板上使用时, 改为生成暗门"}, -- We Need To Go Deeper!
	[87] = {"87", "洛基的角", "25%概率向4个方向发射泪弹#{{Luck}} 幸运15: 100%概率"}, -- Loki's Horns
	[91] = {"91", "探窟帽", "揭示相邻房间的类型#{{SecretRoom}} 可以揭示隐藏房和超级隐藏房#阻挡掉落弹幕的伤害"}, -- Spelunker Hat
	[98] = {"98", "圣遗物", "{{SoulHeart}} 每7-8个房间生成1魂心"}, -- The Relic
	[101] = {"101", "光环", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.3#↑ {{Tears}} 射速+0.2#↑ {{Damage}} 伤害+0.3#↑ {{Range}} 射程+1.5#{{HealingRed}} 治疗1红心"}, -- The Halo
	[106] = {"106", "大爆弹先生", "↑ {{Bomb}} 炸弹伤害x1.85#{{Bomb}} +5炸弹"}, -- Mr. Mega
	[107] = {"107", "锯齿剪", "{{Timer}} 在当前房间中获得:#飞行#角色的身体与头分离, 每秒造成23.5点接触伤害"}, -- The Pinking Shears
	[110] = {"110", "妈妈的美瞳", "↑ {{Range}} 射程+1.5#{{Petrify}} 20%概率发射石化泪弹#{{Luck}} 幸运20: 50%概率"}, -- Mom's Contacts
	[114] = {"114", "妈妈的菜刀", "角色的泪弹由可投掷的菜刀取代#{{Damage}} 持拿时菜刀造成2x角色伤害, 蓄力1/3时为上限6x#继续蓄力只会增加投掷距离#返回角色时, 伤害降至2x"}, -- Mom's Knife
	[115] = {"115", "通灵板", "↑ {{Tears}} 射速+0.5#灵体泪弹"},
	[118] = {"118", "硫磺火", "↓ {{Tears}} 射速修正x0.33#{{Chargeable}} 角色的泪弹由可蓄力的鲜血激光取代#{{Damage}} 在0.63秒内造成9x角色伤害"}, -- Brimstone
	[121] = {"121", "怪异蘑菇(大)", "↑ {{Heart}} +1心之容器#↑ {{Damage}} 伤害+1#↑ {{Range}} 射程+1.5#↓ {{Speed}} 移速-0.2"}, -- Odd Mushroom (Large)
	[123] = {"123", "怪物手册", "{{Timer}} 在本层生成1个随机跟班"}, -- Monster Manual
	[126] = {"126", "剃刀片", "↑ {{Damage}} 在当前房间中伤害+1.2#{{Warning}} 对角色造成1心伤害#在房间中首次使用后, 改为造成半心伤害#{{Heart}} 优先消耗红心"},
	[129] = {"129", "桶装猪油", "↑ {{Heart}} +2心之容器#↓ {{Speed}} 移速-0.2"}, -- Bucket of Lard
	[138] = {"138", "圣痕", "↑ {{Heart}} +1心之容器#↑ {{Damage}} 伤害+0.3#{{HealingRed}} 治疗1红心"}, -- Stigmata
	[139] = {"139", "妈妈的钱包", "{{Trinket}} 生成1随机饰品#{{Trinket}} 角色可以持有2个饰品"}, -- Mom's Purse
	[140] = {"140", "鲍勃的诅咒", "{{Bomb}} +5炸弹#{{Poison}} 角色的炸弹会产生毒气#{{Poison}} 免疫中毒"}, -- Bob's Curse
	[142] = {"142", "肩衣", "{{SoulHeart}} 当受伤至半心时, 角色获得1魂心#每房间只会发生一次#离开并重进房间可以再次触发#{{Warning}} 献血不触发"}, --Scapular
	[147] = {"147", "残损铁镐", "使用时, 角色持拿铁镐#持拿时, 允许角色打碎当前房间中接触的石头, 隐藏房入口, 并对敌人造成伤害#攻击时, 降低铁镐的充能#进入新层时, 铁镐完全充能"}, -- Notched Axe
	[148] = {"148", "害虫横行", "受伤时, 生成2-6只蓝苍蝇"}, -- Infestation
	[149] = {"149", "吐根酊", "↑ {{Damage}} 伤害+40#↓ {{Tears}} 射速修正x0.33#↓ {{Range}} 射程x0.8#↓ {{Shotspeed}} 弹速修正x0.8#角色的泪弹呈抛物线射出#{{Poison}} 泪弹会爆炸并使击中的敌人中毒"}, -- Ipecac
	[152] = {"152", "科技II", "↓ {{Tears}} 射速修正x0.67#角色右眼泪弹由持续激光取代#{{Damage}} 激光每秒造成2x角色伤害"}, -- Technology 2
	[153] = {"153", "变异蜘蛛", "↓ {{Tears}} 射速修正x0.42#角色同时发射4颗泪弹"}, -- Mutant Spider
	[155] = {"155", "窥眼", "↑ 左眼伤害修正x1.35#在房间中四处漂浮#每秒造成17.1点接触伤害"}, -- The Peeper
	[158] = {"158", "水晶球", "生成1{{SoulHeart}}魂心/{{Rune}}符文/{{Card}}卡牌#{{Timer}} 揭示全图({{SuperSecretRoom}}超级隐藏房除外)#持有时:#{{PlanetariumChance}} 星象房概率+15%#{{PlanetariumChance}} 若有跳过{{TreasureRoom}}宝箱房则改为100%"}, -- Crystal Ball
	[169] =	{"169", "巨人独眼", "↑ {{Damage}} 伤害+4#↑ {{Damage}} 伤害修正x2#↓ {{Tears}} 射速修正x0.42#泪弹击杀敌人伤害溢出时会穿透敌人前进"}, -- Polyphemus
	[171] = {"171", "蜘蛛屁股", "{{Slow}} 使敌人减速4秒#所有敌人受到10点伤害#被击杀敌人生成蓝蜘蛛"}, -- Spider Butt
	[172] = {"172", "献祭匕首", "环绕物#阻挡弹幕#每秒造成112.5点接触伤害"}, -- Sacrificial Dagger
    [173] = {"173", "主教冠", "{{SoulHeart}} 红心生成时有33%概率由魂心取代"}, -- Mitre
	[176] = {"176", "干细胞", "↑ {{Heart}} +1心之容器#↑ {{Shotspeed}} 弹速+0.16#{{HealingRed}} 治疗1红心"}, -- Stem Cells
	[178] = {"178", "圣水", "{{Throwable}} 向角色发射方向投掷自身#击中敌人时, 造成7点伤害并破碎#{{Petrify}} 留下的水迹能石化敌人并造成伤害"}, -- Holy Water
	[180] = {"180", "黑豆", "{{Poison}} 受伤时, 角色放出一连串屁#{{Poison}} 屁会留下毒气并偏转弹幕"},
	[182] = {"182", "圣心", "↑ {{Heart}} +1心之容器#↑ {{Damage}} 伤害修正x2.3#↑ {{Damage}} 伤害+1#↓ {{Tears}} 射速-0.4#↓ {{Shotspeed}} 弹速-0.25#{{HealingRed}} 回满血#追踪泪弹"}, -- Sacred Heart
	[184] = {"184", "圣杯", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心#飞行"}, -- Holy Grail
	[186] = {"186", "血之权利", "对所有敌人造成40点伤害#{{Warning}} 对角色造成1心伤害#在房间中首次使用后, 改为造成半心伤害#{{Heart}} 优先消耗红心"},
	[189] = {"189", "超级食肉男孩死忠粉", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.2#↑ {{Tears}} 射速+0.2#↑ {{Damage}} 伤害+0.3#↑ {{Range}} 射程+2.5#{{HealingRed}} 回满血"}, -- SMB Super Fan
	[192] = {"192", "心灵感应傻瓜式教程", "{{Timer}} 在当前房间中获得:#↑ {{Range}} 射程+3#追踪泪弹"}, -- Telepathy for Dummies
	[193] = {"193", "生肉！", "↑ {{Heart}} +1心之容器#↑ {{Damage}} 伤害+0.3#{{HealingRed}} 治疗1红心"}, -- MEAT!
	[194] = {"194", "魔力八号球", "↑ {{Shotspeed}} 弹速+0.16#{{Card}} 生成1卡牌#{{PlanetariumChance}} 星象房概率+15%"}, -- Magic 8 Ball
	[197] = {"197", "耶稣果汁", "↑ {{Damage}} 伤害+0.5#↑ {{Range}} 射程+1.5"}, -- Jesus Juice
	[203] = {"203", "慈善捆绑包", "掉落物有50%概率成对出现"}, -- Humbling Bundle
	[205] = {"205", "锋利插头", "{{Battery}} 使用未完全充能的主动道具时, 以半心充能1格#{{Heart}} 优先消耗红心"}, -- Sharp Plug
	[206] = {"206", "断头台", "↑ {{Tears}} 射速+0.5#↑ {{Damage}} 伤害+1#角色的头变成环绕物, 不会承受受伤, 每秒造成56点接触伤害"}, -- Guillotine
	[211] = {"211", "蜘蛛宝宝", "受伤时, 生成3-5只蓝蜘蛛"}, -- Spiderbaby
	[214] = {"214", "贫血", "↑ {{Range}} 射程+1.5#{{Timer}} 受伤时, 在房间中留下血迹#血迹每秒造成6点伤害"}, -- Anemic
	[218] = {"218", "胎盘", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心#{{HealingRed}} 每分钟50%概率治疗半红心"}, -- Placenta
	[219] = {"219", "旧绷带", "↑ {{EmptyHeart}} +1空心之容器#{{Heart}} 受伤时, 20%概率生成1红心"}, -- Old Bandage
	[222] =	{"222", "反重力", "↑ {{Tears}} 射速+1#按住发射键会使泪弹悬空#松开后, 所有泪弹会向发射方向继续前进"}, -- Anti-Gravity
	[223] = {"223", "纵火狂", "{{Bomb}} +5炸弹#免疫爆炸和火焰#{{HealingRed}} 受爆炸击中时治疗半红心"}, -- Pyromaniac
	[224] = {"224", "柯吉猫的身体", "↑ {{Tears}} 射速+0.5#↓ {{Range}} 射程修正x0.8#泪弹击中后会分裂为4颗#分裂的泪弹造成的伤害减半"}, -- Cricket's Body
	[225] = {"225", "兽性面具", "{{SoulHeart}} 受伤时, 8%概率生成1魂心#{{Luck}} 每级幸运+2%概率#{{HalfHeart}} 敌人死亡时概率掉落1半红心"}, -- Gimpy
	[226] = {"226", "黑莲花", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心#{{SoulHeart}} +1魂心#{{BlackHeart}} +1黑心"}, -- Black Lotus
	[228] = {"228", "妈妈的香水", "↑ {{Tears}} 射速+0.5#{{Fear}} 15%概率发射恐惧泪弹"}, -- Moms Perfume
	[229] = {"229", "萌死戳的肺", "↓ {{Tears}} 射速修正x0.23#{{Chargeable}} 泪弹可蓄力并在松开时散射"}, -- Monstro's Lung
	[230] = {"230", "亚巴顿", "↑ {{Speed}} 移速+0.2#↑ {{Damage}} 伤害+1.5#↓ {{BlackHeart}} 将所有心之容器转换为黑心#{{BlackHeart}} +2黑心#{{Fear}} 15%概率发射恐惧泪弹"}, -- Abaddon
	[232] = {"232", "怀表", "↑ {{Speed}} 移速+0.3#{{Slow}} 使房间中的所有敌人的攻击和移速降至80%"}, -- Stop Watch
	[233] = {"233", "小小星球", "↑ 射程+7#灵体泪弹#角色的泪弹环绕在角色周围"}, -- Tiny Planet
	[245] = {"245", "完美视力", "↓ {{Damage}} 伤害修正x0.8#角色同时发射2颗泪弹"}, -- 20/20
	[248] = {"248", "虫群之心", "蓝蜘蛛/蓝苍蝇造成的伤害翻倍#蜘蛛/苍蝇类跟班变得更强"}, -- Hive Mind
	[253] = {"253", "魔法血痂", "↑ {{Heart}} +1心之容器#↑ {{Luck}} 幸运+1#{{HealingRed}} 治疗1红心"}, -- Magic Scab
	[254] = {"254", "血块", "↑ {{Damage}} 左眼伤害+1#↑ {{Range}} 左眼射程+2.75"}, -- Blood Clot
	[256] = {"256", "炙热炸弹", "{{Bomb}} +5炸弹#{{Burning}} 角色的炸弹造成接触伤害#{{Burning}} 角色的炸弹爆炸时会留下火焰#{{Burning}} 免疫火焰(弹幕除外)"}, -- Hot Bombs
	[261] = {"261", "眼球突出", "↑ {{Damage}} 伤害+0.5#↓ 泪弹前进越远伤害越低#泪弹在最近时近距离造成3x伤害, 0.8秒后无伤害"}, -- Proptosis
	[262] = {"262", "遗失的书页2", "{{BlackHeart}} +1黑心#受伤至1心时, 对房间中所有敌人造成伤害#{{Collectible35}} 黑心和类似死灵之书的效果造成的伤害翻倍"}, -- Missing Page 2
	[263] = {"263", "透明符文", "{{Rune}} 拾起时, 生成1符文#{{Rune}} 触发角色持有的符文/魂石的效果"}, -- Clear Rune (Repentance item)
	[264] = {"264", "智能苍蝇", "环绕物#每秒造成6.5点接触伤害#角色受伤前, 阻挡弹幕#角色受伤后, 追击附近敌人"},
	[272] = {"272", "大美蝇", "友好的爆炸苍蝇#爆炸造成100点伤害#{{Warning}} 爆炸也会伤到角色"}, -- BBF
	[273] = {"273", "鲍勃的脑浆子", "向角色发射方向冲刺#接触到敌人时爆炸#{{Poison}} 爆炸造成100点伤害并使敌人中毒#{{Warning}} 爆炸也会伤到角色"}, -- Bob's Brain
	[274] = {"274", "生死之交", "受伤时, 在房间中生成1个中范围环绕物#环绕物每秒造成150点接触伤害"}, -- Best Bud
	[275] = {"275", "硫磺火宝宝", "{{Chargeable}} 蓄力并发射{{Collectible118}}硫磺火激光#激光在0.63秒内造成24点伤害"}, -- Lil Brimston
	[276] = {"276", "以撒的心脏", "角色无敌#生成跟随角色的心脏#角色发射时心脏蓄力, 停止发射时释放散射泪弹#{{Warning}} 心脏受伤时, 角色也会受伤"}, -- Isaac's Heart
	[278] = {"278", "黑暗乞丐", "{{Heart}} 捡起附近的红心#每捡起1.5红心, 生成1黑心/符文/卡牌/胶囊/蜘蛛"}, -- Dark Bum
	[280] = {"280", "长腿蛛妹妹", "在有敌人的房间中随机生成蓝蜘蛛, 最多5只#{{Charm}} 魅惑接触的敌人"}, -- Sissy Longlegs
	[283] = {"283", "一百面骰", "复制房间中的1掉落物#重置角色的移速, 射速, 伤害, 射程和被动道具#重置房间中的所有底座道具, 掉落物和石头#重新开始当前房间, 重生所有敌人并降级"}, -- D100
	[285] = {"285", "十面骰", "使房间中所有敌人降级#例如, 所有红苍蝇变成黑苍蝇"}, -- D10
	[286] = {"286", "空白卡牌", "触发角色持有的卡牌的效果"}, -- Blank Card
	[287] = {"287", "秘密之书", "高亮当前房间中的暗门石头与标记石头#{{Timer}} 在本层获得以下三种效果之一:#{{Collectible54}} 藏宝图#{{Collectible21}} 指南针 #{{Collectible246}} 蓝地图#只获得尚未激活的效果#如果三者都已拥有, 获得X光透视效果"}, -- Book of Secrets
	[288] = {"288", "蜘蛛盒", "生成4-8只蓝蜘蛛"}, -- Box of Spiders
	[289] = {"289", "红蜡烛", "投掷红火#火焰可造成接触伤害, 阻挡弹幕, 在造成或阻挡4次伤害后或10秒后消失"}, -- Red Candle
	[291] = {"291", "冲水！", "使非头目敌人变成大便#立即击杀便便类敌人和头目#熄灭火堆并将房间充满水#将岩浆坑变为可行走的地面"}, -- Flush!
	[292] = {"292", "撒但圣经", "{{BlackHeart}} +1黑心#{{DevilRoom}} 在头目战斗前使用, 头目房道具会变成恶魔交易#购买恶魔交易与在恶魔房后果相同#不影响虚空层的底座道具"}, -- Satanic Bible
	[293] = {"293", "坎卜斯的头", "{{Collectible118}} 在四个方向上发射硫磺火激光#每道激光在1.33秒内造成200点伤害"},
	[294] = {"294", "棉豆", "击退附近的敌人和弹幕#将敌人击退到障碍物上会造成10点伤害"}, -- Butter Bean
	[295] = {"295", "魔术手指", "对房间中所有敌人造成2x角色伤害+10的伤害#{{Coin}} 花费1硬币"}, -- Magic Fingers
	[296] = {"296", "转换器", "{{Heart}} 将1魂心/黑心转换为1心之容器"}, -- Converter
	-- NOTE FOR LOCALIZERS: There is code to highlight the text of your current floor
	-- For it to work, only use line breaks or semicolons to separate floor details, and use the same order as English
	[297] = {"297", "潘多拉魔盒", "{{NoLB}}根据所在层生成奖励:#1章1: 2{{SoulHeart}}; 1章2: 2{{Bomb}}+2{{Key}}#{{NoLB}}2章1: 1{{BossRoom}}道具; 2章2: 2章1+2{{SoulHeart}}#3章1: 4{{SoulHeart}}; 3章2: 20{{Coin}}#4章1: 2{{BossRoom}}道具; 4章2: {{Collectible33}}圣经#???/虚空: 无#阴间: 1{{DevilRoom}}道具+1{{BlackHeart}}; 教堂: 1{{AngelRoom}}道具+1{{EternalHeart}}#{{NoLB}}暗室: 解锁{{Collectible523}}搬家盒; 玩具箱: 1{{Coin}}#家: {{Collectible580}}红钥匙"}, -- Pandora's Box
	[300] = {"300", "白羊座", "↑ {{Speed}} 移速+0.25#移速大于0.85时, 角色免疫接触伤害, 并对敌人造成25点接触伤害"}, -- Aries
	[307] = {"307", "摩羯座", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.1#↑ {{Tears}} 射速+0.5#↑ {{Damage}} 伤害+0.5#↑ {{Range}} 射程+0.75#+1{{Coin}}硬币, {{Bomb}}炸弹, {{Key}}钥匙#{{HealingRed}} 治疗1红心"}, -- Capricorn
	[308] = {"308", "宝瓶座", "角色留下水迹#{{Damage}} 水迹每秒造成0.66x角色伤害, 并继承角色的泪弹效果"}, -- Aquarius
	[309] =	{"309", "双鱼座", "↑ {{Tears}} 射速+0.5#↑ {{Tearsize}} 泪弹尺寸+0.12#提高泪弹击退力"}, -- Pisces
	[310] =	{"310", "夏娃的睫毛膏", "↑ {{Damage}} 伤害修正x2#↓ {{Tears}} 射速修正x0.66#↓ {{Shotspeed}} 弹速-0.5"},
	[314] = {"314", "霹雳大腿", "↑ {{Heart}} +1心之容器#↓ {{Speed}} 移速-0.4#{{HealingRed}} 治疗1红心#角色摧毁接触的石头"}, -- Thunder Thighs
	[315] = {"315", "怪异磁铁", "角色的泪弹吸引敌人, 掉落物和饰品#泪弹落地时效果吸引更强"}, -- Strange Attractor
	[316] = {"316", "诅咒之眼", "蓄力发射5颗泪弹#{{Warning}} 蓄力未满时受伤会将角色传送至随机房间"}, -- Cursed Eye
	[319] = {"319", "该隐的另一只眼", "随机方向发射与角色相同效果的泪弹#{{Damage}} 造成0.75x角色伤害"}, -- Cain's Other Eye
	[320] = {"320", "???唯一的朋友", "可控制的苍蝇#造成每秒15点接触伤害"}, -- ???'s Only Friend
	[323] = {"323", "以撒的泪盆", "向8个方向发射泪弹#泪弹复制角色泪弹的效果, 外加5点伤害#发射泪弹时充能"},
	[325] = {"325", "剪刀", "{{Timer}} 当前房间中将角色的头变为不动的跟班#独立控制角色身体, 向发射方向抛射泪弹"},
	[326] = {"326", "生命之息", "按住使用键时消耗充能条#充能条为空时角色暂时无敌#无敌时, 角色接触到敌人会召唤光柱#如果阻挡伤害时机完美, 则发射4向圣光并获得短暂护盾#{{Warning}} 按住过久会对角色造成伤害"}, -- Breath of Life
	[328] = {"328", "底片", "↑ {{Damage}} 伤害+1#若不多于半红心时受伤, 则对房间中所有敌人造成伤害"}, -- The Negative
	[330] = {"330", "豆奶", "↑ {{Tears}} 射速修正x5.5#↓ {{Damage}} 伤害修正x0.2#↓ {{Tearsize}} 泪弹尺寸-0.3#大幅降低击退力"}, -- Soy Milk
	[331] = {"331", "神性", "↑ {{Damage}} 伤害+0.5#↓ {{Tears}} 射速-0.3#↓ {{Shotspeed}} 弹速-0.3#追踪泪弹#{{Damage}} 泪弹具有光环, 每秒造成60点伤害"}, -- Godhead
	[336] = {"336", "烂洋葱", "↑ {{Tearsize}} 泪弹尺寸+0.22#↓ {{Range}} 射程-1.5#↓ {{Shotspeed}} 弹速-0.4#穿刺+灵体泪弹"}, -- Dead Onion
	[339] = {"339", "安全别针", "↑ {{Range}} +2.5射程#↑ {{Shotspeed}} +0.16弹速#{{BlackHeart}} +1黑心"}, -- Safety Pin
	[342] = {"342", "蓝盖蘑菇", "↑ {{Heart}} +1心之容器#↑ {{Tears}} 射速+0.7#↓ {{Shotspeed}} 弹速-0.16#{{HealingRed}} 治疗1红心"}, -- Blue Cap
	[344] = {"344", "火柴盒", "{{BlackHeart}} +1黑心#{{Bomb}} 生成3炸弹#{{Trinket41}} 生成火柴棍"}, -- Match Book
	[345] = {"345", "合成油脂", "↑ {{Damage}} 伤害+1#↑ {{Range}} 射程+2.5"}, -- Synthoil
	[346] = {"346", "零食", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心"}, -- A Snack
	[349] = {"349", "木制镍币", "{{Coin}} 59%概率生成1随机硬币"}, -- Wooden Nickel
	[352] = {"352", "玻璃大炮", "{{Damage}} 发射1颗巨大的穿刺灵体泪弹, 造成10x角色伤害#{{Warning}} 持有时受伤:#↓ 额外受到2心伤害#↓ 大炮破碎持续数个房间#↑ {{Range}} 在当前房间中射程+1.5, 并留下血迹#额外伤害不会击杀以撒#自伤不会触发该效果"}, -- Glass Canon
	[354] = {"354", "琥珀爆米花", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心#{{Trinket}} 生成1饰品"}, -- Crack Jacks
	[355] = {"355", "妈妈的珍珠项链", "↑ {{Range}} 射程+2.5#↑ {{Luck}} 幸运+1#{{SoulHeart}} +1魂心"}, -- Mom's Pearls
	[360] = {"360", "淫魔", "发射泪弹, 效果和属性与角色一致#{{Damage}} 造成0.75x角色伤害"}, -- Incubus
	[365] = {"365", "迷路苍蝇", "沿着房间中的墙/障碍物行进#每秒造成30点接触伤害#吸引附近敌人的仇恨"},
	[366] = {"366", "分裂炸弹", "{{Bomb}} +5炸弹#角色的炸弹会炸成4-5个小炸弹"}, -- Scatter Bombs
	[367] = {"367", "粘性炸弹", "{{Bomb}} +5炸弹#{{Slow}} 角色的炸弹会粘在敌人身上并留下减速水迹#用炸弹击杀敌人会生成蓝蜘蛛"},
	[368] =	{"368", "溢泪症", "↑ {{Tears}} 持续向单方向发射会逐渐提高射速, 最多为原来的2x"}, -- Epiphora
	[369] = {"369", "连续统", "↑ {{Range}} 射程+3#灵体泪弹#泪弹会过屏幕, 从另一边回来"}, -- Continuum
	[370] = {"370", "玩偶先生", "↑ {{Tears}} +0.7射速#↑ {{Range}} +2.5射程#{{UnknownHeart}} 拾起时生成3随机心"}, -- Mr. Dolly
	[374] = {"374", "圣光", "10%概率发射圣光泪弹, 击中时会产生光柱#{{Luck}} 幸运9: 50%概率#{{Damage}} 光柱造成3x角色伤害"}, -- Holy Light
	[375] = {"375", "寄居骷髅帽", "免疫爆炸和掉落弹幕#25%概率反弹敌人弹幕"}, -- Host hat
	[376] = {"376", "补货", "商店物品购买后会立刻补货#每次补货价格都会提高"}, -- Restock
	[380] = {"380", "充钱游戏", "{{Coin}} +5硬币#{{Coin}} 钥匙方块, 门和箱子必须用硬币打开而不是钥匙"}, -- Pay To Play
	[382] = {"382", "友好球", "可以扔向敌人将其捕捉#{{Friendly}} 下一次使用则会生成相同的友好敌人#靠近捕捉后的球会立即将道具充能"}, -- Friendly Ball
	[386] = {"386", "D12", "将障碍物重置为其他随机类型的障碍物(大便/罐子/TNT/红大便/石头等)#小概率重置为按钮/击杀按钮/暗门/活板门"}, -- D12
	[384] = {"384", "肉山宝宝", "{{Chargeable}} 弹出并在房间中反弹, 速度基于蓄力时间#根据蓄力时间, 每次击中造成5-20点接触伤害"}, -- Lil Gurdy
	[389] = {"389", "符文袋", "{{Rune}} 每7-8个房间生成1随机符文/魂石"}, -- Rune Bag
	[391] = {"391", "背叛", "敌人弹幕会击中其他敌人, 并引起内讧"},
	[393] = {"393", "蛇蝎之吻", "{{Poison}} 15%概率发射有毒泪弹#{{Poison}} 使接触的敌人中毒#{{BlackHeart}} 因接触而中毒的敌人死亡时, 20%概率掉落黑心"}, -- Serpent`s Kiss
	[394] = {"394", "十字准星", "↑ {{Tears}} 射速+0.7#↑ {{Range}} 射程+3#角色自动向地上的可控红色标记发射泪弹#跟班也向标记发射#按掉落键({{ButtonRT}})停止发射并重置标记位置"}, -- Marked
	[395] = {"395", "科技X", "{{Chargeable}} 角色的泪弹由可蓄力的激光环取代#激光环尺寸和伤害随蓄力时间增加, 最多增加1x"}, -- Tech X
	[397] = {"397", "牵引光束", "↑ {{Tears}} 射速+1#↑ {{Range}} 射程+2.5#↑ {{Shotspeed}} 弹速+0.16#角色的泪弹受角色面前的光束指引"}, -- Tractor Beam
	[399] = {"399", "虚空之喉", "{{Chargeable}} 持续发射泪弹2.35秒后, 松开发射键会产生黑硫磺火圈#黑圈在2秒内造成30x角色伤害"}, -- Maw of the Void
	[401] = {"401", "爆炸物", "25%概率发射粘性泪弹#粘住的泪弹在几秒后变大并爆炸, 造成1x角色伤害+60的伤害"}, -- Explosivo
	[404] = {"404", "放屁宝宝", "阻挡弹幕#受击时, 10%概率放屁, 效果为{{Charm}}魅惑/{{Poison}}中毒/击退三种其一#屁造成5-6点伤害"}, -- Farting Baby
	[405] = {"405", "恶性漏洞", "{{Throwable}} 可投掷(双击发射键)#重置其接触到的敌人和掉落物"}, -- GB Bug
	[407] = {"407", "纯洁", "↑ 根据光环颜色对角色属性进行增强#受伤时, 移除光环, 在下个房间获得新的光环#{{ColorYellow}}黄色{{CR}} = ↑ {{Speed}} 移速+0.5#{{ColorBlue}}蓝色{{CR}} = ↑ {{Tears}} 射速+2#{{ColorRed}}红色{{CR}} = ↑ {{Damage}} 伤害+4#{{ColorOrange}}橙色{{CR}} = ↑ {{Range}} 射程+3"},
	[408] = {"408", "祭祀之刃", "25%概率在被击杀敌人周围生成黑色硫磺火圈#黑圈2秒内造成30x角色伤害#{{Luck}} 每级幸运+2.5%概率"}, -- Athame
	[415] = {"415", "光明之冠", "{{SoulHeart}} +2魂心#若角色无不满的心之容器:#↑ {{Damage}} 伤害修正x2#↓ {{Shotspeed}} 弹速-0.3#受伤后, 在当前房间中效果消失"}, -- Crown Of Light
	[416] = {"416", "深口袋", "{{Coin}} 若清理房间没有奖励, 则生成1-3硬币#{{Coin}} 提高硬币上限至999"}, -- Deep Pockets
	[417] = {"417", "魅魔", "在房间中漂浮的跟班, 产生伤害光环, 每秒造成7.5-10点伤害#↑ {{Damage}} 站在光环中伤害修正x1.5"}, -- Succubus
	[419] = {"419", "传送2.0", "传送至未探索的随机房间#等级: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}{{BossRushRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{Planetarium}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"},
	[421] = {"421", "腰豆", "{{Charm}} 魅惑近距离的所有敌人"}, -- Kidney Bean
	[422] = {"422", "发光沙漏", "将角色带回上个房间, 回退所有使用时房间的行动#每层仅可使用三次#{{Collectible66}} 用尽次数后与沙漏作用一致, 即使敌人减速8秒"}, -- Glowing Hourglass
	[426] = {"426", "狂热粉丝", "模仿角色移动, 有0.66秒延迟#每秒造成30点接触伤害"}, -- Obsessed Fan
	[430] = {"430", "狙击蝇老爹", "模仿角色移动, 有0.66秒延迟#向附近敌人发射泪弹, 造成1x角色伤害"}, -- Papa Fly
	[431] = {"431", "多维宝宝", "模仿角色移动, 有0.66秒延迟#经过它的泪弹会分成2个并有射程+弹速加成"}, -- Multidimensional Baby
	[432] = {"432", "闪光炸弹", "{{Bomb}} +5炸弹#角色的炸弹爆炸时, 63%概率生成1随机掉落物, 15%概率魅惑炸到的敌人#每次生成掉落物后, 本层上述生成概率-1%"}, -- Glitter Bombs
	[433] = {"433", "我的影子", "紧跟着角色的影子#{{Friendly}} 当敌人接触影子时, 在当前房间中生成1个友好的黑蛆# 黑蛆每秒造成8.7点伤害"},
	[437] = {"437", "七面骰", "重新开始房间并重生所有敌人#能够从同一房间获得多次清理房间奖励"}, -- D7
	[440] = {"440", "肾结石", "角色约每25秒停止发射并蓄力, 释放散射泪弹和1颗肾结石"}, -- Kidney Stone
	[442] = {"442", "黑王子之冠", "红心为1时:#↑ {{Tears}} 射速+2#↑ {{Range}} 射程+1.5#↑ {{Shotspeed}} 弹速+0.2"}, -- Dark Princes Crown
	[444] = {"444", "铅笔", "角色每发射15颗泪弹, 抛射大量泪弹"}, -- Lead Pencil
	[448] = {"448", "玻璃碎片", "受伤时:#{{Heart}} 25%概率生成1红心#{{BleedingOut}} 角色流血, 向角色发射方向喷泪弹#流血每20秒造成半红心伤害#治疗红心, 红心用尽或下一次受伤致死时, 流血停止"}, -- Shard of Glass
	[450] = {"450", "贪婪的眼睛", "{{Damage}} 每发射20颗泪弹, 发射1颗的硬币泪弹, 造成1.5x角色伤害+10的伤害#{{Petrify}} 被硬币泪弹击中的敌人石化并变为金块#{{Coin}} 击杀金敌人掉落1-4硬币#{{Warning}} 发射硬币泪弹消耗1硬币"}, -- Eye of Greed
	[451] = {"451", "塔罗牌桌布", "{{Card}} 生成1卡牌#{{Card}} 使用的卡牌效果翻倍或增强"}, -- Tarot Cloth
	[453] = {"453", "复杂性骨折", "↑ {{Range}} 射程+1.5#泪弹击中时碎成1-3个小骨片"}, -- Compound Fracture
	[455] = {"455", "爸爸丢失的硬币", "↑ {{Range}} 射程+2.5#{{Luck}} 生成1幸运硬币"},
	[456] = {"456", "夜宵", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心"}, -- Midnight Snack
	[459] = {"459", "鼻窦炎", "20%概率发射粘性鼻屎#{{Damage}} 鼻屎每秒造成1x角色伤害, 能粘住10秒#{{Luck}} 不受幸运影响"}, -- Sinus Infection
	[462] = {"462", "彼列之眼", "↑ {{Range}} 射程+1.5#穿刺泪弹#泪弹击中敌人后, 获得追踪效果并伤害翻倍"}, -- Eye of Belial
	[464] = {"464", "平衡符号", "{{SoulHeart}} +2魂心#房间清理奖励和精英怪掉落角色最需要的掉落物"}, -- Glyph of Balance
	[468] = {"468", "阴影", "跟随角色移动, 有0.66秒延迟#每秒造成75点接触伤害#{{Friendly}} 造成666伤害后被角色吸收, 角色获得接触伤害效果, 并生成友好的黑蛆"}, -- Shade
	[472] = {"472", "国王宝宝", "其他跟班都会跟着他, 并自动向敌人发射#角色发射时停止移动#停止发射时传送回角色位置"}, -- King Baby
	[474] = {"474", "损坏的玻璃大炮", "使用时变回玻璃大炮"}, -- Broken Glass Canon
	[476] = {"476", "一面骰", "复制房间中1随机掉落物#复制的掉落物可能与原来的不同"}, -- D1
	[477] = {"477", "虚空", "消耗房间中所有底座道具:#主动道具: 后续每次使用虚空时会激活其效果#↑ 被动道具: 提升2项随机属性"}, -- Void
	[487] = {"487", "土豆削皮刀", "{{EmptyHeart}} 移除1心之容器, 获得:#↑ {{Damage}} 伤害+0.2#{{Collectible73}} 肉块#{{Timer}} 当前房间中获得:#↑ {{Range}} 射程+1.5#{{Collectible214}} 留下血迹"},
	[489] = {"489", "无限面骰", "可以通过掉落键({{ButtonRT}})更改为任意骰子道具({{Collectible723}}计数二十面骰除外)#"}, -- D Infinity
	[491] = {"491", "毒瘾宝宝", "{{Pill}} 每7个房间生成1随机胶囊#{{Poison}} 使用胶囊会使房间中所有敌人中毒"}, -- Acid Baby
	[493] = {"493", "肾上腺素", "↑ {{Damage}} 空心之容器能提高伤害#空心之容器越多, 随后的伤害加成越高"}, -- Adrenaline
	[494] = {"494", "雅各布天梯", "泪弹击中时, 生成1道电弧#电弧造成0.5x角色伤害#电弧可电穿最多4个其他敌人"}, -- Jacobs Ladder
	[495] = {"495", "断魂椒", "8%概率发射蓝火, 能阻挡弹幕并造成接触伤害#{{Luck}} 幸运10: 50%概率#火焰不断缩小, 2秒后消失"}, -- Ghost Pepper
	[496] = {"496", "安乐死", "3.33%概率发射针#{{Luck}} 幸运13: 25%概率#针会立即击杀通常敌人, 并爆出10颗泪弹#{{Damage}} 针击中头目造成3x角色伤害"}, -- Euthanasia
	[497] = {"497", "迷彩内裤", "{{Confusion}} 进入房间时, 使所有敌人混乱并使角色伪装, 直到角色开始发射#↑ {{Speed}} 伪装时移速+0.5#解除伪装时, 对角色周围造成伤害, 并获得非常短暂的射速和伤害提升"}, -- Camo Undies
	[500] = {"500", "袋中袋", "每7-8个房间生成1福袋"}, -- Sack of Sacks
	[501] = {"501", "贪婪的胃袋", "{{Heart}} 角色每持有25硬币+1心之容器"}, -- Greed's Gullet
	[503] = {"503", "小魔角", "5%概率发射能召唤巨角恶魔的手的泪弹#{{Luck}} 运气15: 20%概率#手会立即杀死敌人或对头目造成36点伤害#角色每秒造成7点接触伤害"}, -- Little Horn
	[504] = {"504", "棕色粪块", "生成1只向敌人发射的苍蝇炮塔#泪弹造成3.5点伤害"}, -- Brown Nugget
	[506] = {"506", "背刺", "{{BleedingOut}} 若泪弹击中敌人后背, 则造成的伤害翻倍并造成流血, 使敌人留下水迹并在移动时受伤"}, -- Backstabber
	[507] = {"507", "尖头吸管", "{{Damage}} 对所有敌人造成1x角色伤害+敌人最大血量10%的伤害#{{HalfHeart}} 造成伤害时, 15%概率生成半红心" },
	[508] = {"508", "妈妈的剃刀", "{{BleedingOut}} 能造成流血的环绕物, 使敌人在移动时受伤#{{Damage}} 每秒造成1.5x角色伤害"},
	[509] = {"509", "血丝眼", "附近有敌人时, 每0.33秒发射一颗泪弹的环绕物#泪弹造成3.5点伤害#每秒造成20点接触伤害"}, -- Bloodshot Eye
	[514] = {"514", "损坏的调制解调器", "随机间隔使一些敌人和弹幕短暂停滞#暂停的弹幕消失#25%概率使清理房间奖励翻倍"}, -- Broken Modem
	[517] = {"517", "快速炸弹", "{{Bomb}} +7炸弹#移除放置炸弹的冷却#炸弹相互之间不会击退"}, -- Fast Bombs
	[522] = {"522", "念力", "使靠近角色的敌人弹幕停滞3秒, 结束后弹幕会被抛开#效果期间推开靠近的敌人"}, -- Telekinesis
	[523] = {"523", "搬家盒", "使用时, 储存当前房间中最多10掉落物#再次使用将储存物放回地上#允许角色在房间之间搬东西"}, -- Moving Box
	[524] = {"524", "科技零", "泪弹以电弧连接#{{Damage}} 电弧每秒造成4.5x角色伤害"}, -- Technology Zero
	[531] = {"531", "泪血症", "↑ {{Damage}} 伤害+1#↑ {{Damage}} 伤害修正x1.5#↓ {{Tears}} 射速修正x0.33#↓ {{Range}} 射程x0.8#角色的泪弹呈抛物线前进, 击中时分裂成更小的泪弹"}, -- Haemolacria
	[543] = {"543", "圣地大便", "受伤时, 生成白大便#在大便光环中时:#↑ {{Tears}} 射速修正x2.5#↑ {{Damage}} 伤害修正x1.2#追踪泪弹#50%概率阻挡伤害"}, -- Hallowed Ground
	[549] =	{"549", "脆骨症", "{{EmptyBoneHeart}} 角色所有的心之容器由6空骨心取代#失去骨心时:#↑ {{Tears}} 射速+0.4#向四周方向发射8颗骨头泪弹"}, -- Brittle Bones
	[552] =	{"552", "妈妈的铲子", "生成通往下一层的活板门#{{LadderRoom}} 在有装饰(草/碎石/纸/宝石等)的地板上使用时, 改为生成暗门#{{Warning}} 在\"暗室\"的土丘上使用铲子"}, -- Brittle Bones
	[553] = {"553", "毛霉菌病", "25%概率发射粘性孢子泪弹#{{Luck}} 不受幸运影响#孢子命中后2.5秒爆炸, 造成伤害, 使附近敌人中毒并释放更多孢子"}, --  Mucormycosis
	[554] = {"554", "恐怖如斯", "{{Fear}} 使近距离的敌人恐惧"}, --  2Spooky
	[555] = {"555", "金剃刀片", "#{{Coin}} 拾起时+5硬币#{{Timer}} 花费5{{Coin}}硬币, 并在当前房间中获得:#↑ {{Damage}} 伤害+1.2"}, --  Golden Razor
	[556] = {"556", "炼金硫磺", "{{Timer}} 在当前房间中获得{{Collectible118}}硫磺火#多次使用使伤害更高, 激光更大"}, --  Sulfur
	[557] = {"557", "幸运饼干", "获得其一:#1条预言#{{SoulHeart}} 1魂心#{{Rune}} 1符文/魂石#{{Card}} 1塔罗牌#{{Trinket}} 1饰品"}, --  Fortune Cookie
	[558] = {"558", "眼瘤", "概率向随机方向发射1-3颗额外泪弹#{{Luck}} 不受运气影响"}, --  Eye Sore
	[559] = {"559", "220伏", "反复电击附近敌人#{{Damage}} 电击每秒造成3.75x角色伤害#电弧可电穿最多4个其他敌人"}, --  120 Volt
	[560] = {"560", "好疼", "{{Timer}} 受伤时, 在当前房间中获得:#↑ {{Tears}} 首次受伤射速+1.2#↑ {{Tears}} 后续受伤射速+0.4#在角色周围释放10颗泪弹"}, --  It Hurts
	[561] = {"561", "杏仁奶", "↑ {{Tears}} 射速修正x4#↓ {{Damage}} 伤害修正x0.3#↓ {{Tearsize}} 泪弹尺寸-0.16#泪弹随机获得蠕虫饰品和一些道具的效果"}, --  Almond Milk
	[562] = {"562", "谷底石", "↑ 本局游戏中属性不会再降低"}, --  Rock Bottom
	[563] = {"563", "魅彩炸弹", "{{Bomb}} +5炸弹#炸弹具有随机爆炸效果"}, --  Nancy Bombs
	[564] = {"564", "肥皂", "↑ {{Tears}} 射速+0.5#↑ {{Shotspeed}} 弹速+0.2"}, --  A Bar of Soap
	[565] = {"565", "嗜血小宠", "追击敌人#击杀15个敌人后, 会造成更多伤害, 每击杀10个敌人掉落半红心, 但也会尝试对角色造成伤害#击杀40个敌人后, 会造成更多伤害, 掉落整红心, 可以摧毁石头#对其造成足够多伤害可使其回到第一阶段"}, --  Blood Puppy
	[566] = {"566", "捕梦网", "{{HalfSoulHeart}} 进入新层时+1半魂心#在每层过场噩梦中显示下一层的头目战和宝箱房道具"}, --  Dream Catcher
	[567] = {"567", "逾越节蜡烛", "↑ {{Tears}} 若清理房间且不受伤害, 则射速+0.4#最多+2{{ColorSilver}}(5个房间){{CR}}"}, --  Paschal Candle
	[568] = {"568", "神圣干预", "双击发射键产生护盾#护盾持续1秒, 能推开敌人, 反弹敌人弹幕和激光"}, --  Divine Intervention
	[569] = {"569", "血誓", "{{Warning}} 进入新层时, 吸走角色的所有红心, 但根据失去的红心获得移速和伤害加成#致死时保留半红心#对于受击效果, 每失去半红心都算作单独一击"}, --  Blood Oath
	[570] = {"570", "黏土饼干", "角色的每颗泪弹都有不同的颜色和效果"}, --  Playdough Cookie
	[571] = {"571", "孤儿的袜子", "↑ {{Speed}} 移速+0.3#{{SoulHeart}} +2魂心#免疫水迹和尖刺"}, --  Orphan Socks
	[572] = {"572", "玄秘魔眼", "↑ {{Damage}} 伤害+1#↑ {{Range}} 射程+2#↓ {{Shotspeed}} 弹速-0.16#角色的泪弹飞行时可控"}, --  Eye of the Occult
	[573] = {"573", "无瑕圣心", "↑ {{Heart}} +1心之容器#↑ {{Damage}} 伤害修正x1.2#{{HealingRed}} 回满血#20%概率额外发射1颗环绕灵体泪弹"}, --  Immaculate Heart
	[574] = {"574", "圣体匣", "角色获得造成伤害的光环#敌人越靠近角色, 光环造成的伤害越高"}, --  Monstrance
	[575] = {"575", "侵体蜘蛛", "{{Slow}} 蜘蛛埋在角色头里, 额外发射4颗减速泪弹, 造成1.5点伤害#受伤时, 蜘蛛离开头并追击敌人"}, --  The Intruder
	[576] = {"576", "龌龊之心", "所有粪滴敌人变得友好#摧毁大便时, 生成1-4个粪滴#粪滴类型取决于大便类型#石头可能会由大便取代"}, --  Dirty Mind
	[577] = {"577", "达摩克里斯之剑", "在角色头上悬着剑, 并使底座道具翻倍#有价格或箱子中的道具不翻倍#{{Warning}} 受伤后, 剑每帧有极低概率立即击杀角色#无敌效果可以避免死亡"}, --  Damocles
	[578] = {"578", "免费柠檬水", "生成大范围的黄色水迹#水迹每秒造成24点伤害"}, --  Free Lemonade
	[579] = {"579", "英灵剑", "攻击方式改为挥剑#{{Damage}} 剑造成3x角色伤害+3.5的伤害, 挥剑速度与按发射键速度一样快#{{Chargeable}} 可蓄力发动旋转攻击#满血时发射剑气"}, --  Spirit Sword
	[580] = {"580", "红钥匙", "在常规房间旁产生门形轮廓指示的红色房间#红色房间可以是特殊房间#{{ErrorRoom}} 进入13x13地图范围外的房间时, 将角色传送至错误房"}, --  Red Key
	[581] = {"581", "灵能苍蝇", "追击并反弹敌人弹幕#每秒造成15点接触伤害"}, --  Psy Fly
	[582] = {"582", "迷幻蘑菇", "↑ {{Tears}} 射速+0.75#↓ {{Speed}} 移速-0.03#扭曲画面#每次使用后需要更多充能#离开或清理房间可减弱效果"}, --  Wavy Cap
	[583] = {"583", "罐中火箭", "{{Bomb}} +5炸弹#发射时放置炸弹, 炸弹由发射火箭取代"}, --  Rocket in a Jar
	[584] = {"584", "美德之书", "{{AngelChance}} 持有时, 天使房概率+12.5%#生成1魂火环绕跟班, 发射灵体泪弹但可被摧毁#与其它主动道具组合可产生特殊魂火#{{AngelRoom}} 将第一个恶魔房变为天使房#{{AngelChance}} 恶魔交易后仍会出现天使房"}, --  Book of Virtues
	[585] = {"585", "白玉香膏盒", "必须通过拾起魂心充能, 使用时生成:#{{SoulHeart}} 3{{SoulHeart}}魂心#{{AngelRoom}} 2个天使房道具#{{DevilRoom}} 若已进行过恶魔交易, 则改为2魂心和1个天使房道具"}, --  Alabaster Box
	[586] = {"586", "天堂阶梯", "{{AngelRoom}} 在每层的初始房间生成梯子, 通向特殊{{AngelRoom}}天使房商店"}, --  The Stairway
	[587] = {"587", "", "<道具不存在>"}, -- Menorah (Unused but skripted)
	[588] = {"588", "太阳", "{{BossRoom}} 揭示头目房位置#{{Timer}} 击败头目后, 在本层获得:#↑ {{Damage}} 伤害+3#↑ {{Luck}} 幸运+1#{{Card20}} 太阳的效果#{{Battery}} 将主动道具完全充能#{{CurseBlind}} 移除诅咒"}, --  Sol
	[589] = {"589", "月亮", "每层额外增加1个{{SecretRoom}}隐藏房和{{SuperSecretRoom}}超级隐藏房#每层揭示1个隐藏房#{{Timer}} 隐藏房内有光束, 接触时在本层获得:#↑ {{Tears}} 射速+0.5#↑ {{Tears}} 每层首个光柱额外+0.5射速#{{HalfSoulHeart}} 1半魂心"}, --  Luna
	[590] = {"590", "水星", "↑ {{Speed}} 移速+0.4#大多数门会永久保持打开"}, --  Mercurius
	[591] = {"591", "金星", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心#{{Charm}} 魅惑附近敌人"}, --  Venus
	[592] = {"592", "地球", "↑ {{Damage}} 伤害+1#角色的泪弹由石头取代#石头伤害不定, 可摧毁障碍物并有更强的击退力"}, --  Terra
	[593] = {"593", "火星", "双击移动键使角色冲锋#{{Damage}} 冲锋时角色无敌, 造成4x角色伤害+8的伤害#{{Timer}} 3秒冷却"}, --  Mars
	[594] = {"594", "木星", "↑ {{EmptyHeart}} +2空心之容器#↓ {{Speed}} 移速-0.3#{{HalfHeart}} 治疗半红心#{{Speed}} 不移动时累积最多+0.5移速#{{Poison}} 移动时向后释放毒气#{{Poison}} 免疫中毒"}, --  Jupiter
	[595] = {"595", "土星", "进入房间时生成7颗泪弹在角色周围环绕#这些泪弹持续13秒, 造成1.5x角色伤害+5的伤害#敌人弹幕有概率加入环绕"}, --  Saturnus
	[596] = {"596", "天王星", "{{Freezing}} 角色发射冰冻泪弹, 击杀敌人时使其冻结#可以推开冻结的敌人, 撞碎时向四周发射10个冰锥"}, --  Uranus
	[597] = {"597", "海王星", "{{Tears}} 不发射时3秒内累积射速加成#角色发射时降低射速加成"}, --  Neptunus
	[598] = {"598", "冥王星", "↑ {{Tears}} 射速+0.7#角色大幅缩小, 允许挤过物体#弹幕可以越过角色"}, --  Pluto
	[599] = {"599", "巫毒娃娃头", "{{CursedRoom}} 每层额外生成1个诅咒房#升级{{CursedRoom}}诅咒房的布局和奖励#{{Coin}} 每个诅咒房生成1硬币"}, --  Voodoo Head
	[600] = {"600", "眼药水", "↑ {{Tears}} 左眼射速修正x1.4"}, --  Eye Drops
	[601] = {"601", "痛悔短祷", "↑ {{Tears}} 射速+0.7#{{EternalHeart}} +1永恒之心#{{AngelChance}} 进行过恶魔交易后天使房仍然会出现#{{AngelDevilChance}} 减缓受红心伤害后减少恶魔房/天使房的概率"}, --  Act of Contrition
	[602] = {"602", "会员卡", "{{Shop}} 在商店内生成1个通往地下商店的暗门, 售卖饰品, 符文, 卡牌, 特殊心和任意道具池的道具"}, --  Member Card
	[603] = {"603", "电池组", "{{Battery}} 生成2-4电池#{{Battery}} 将主动道具完全充能"}, --  Battery Pack
	[604] = {"604", "妈妈的手镯", "允许角色举起并投掷石头/TNT/大便/友好粪滴/寄居骷髅等障碍物#举起的东西可以带到其他房间"}, --  Mom's Bracelet
	[605] = {"605", "挖眼勺", "↑ {{Damage}} 右眼伤害修正x1.35#{{Timer}} 在当前房间中召唤1个眼球跟班, 每秒造成36点伤害并留下血迹"}, --  The Scooper
	[606] = {"606", "邪眼裂口", "5%概率发射在落地时生成裂隙的泪弹#{{Luck}} 幸运15: 20%概率#裂隙每秒造成3x角色伤害, 并吸引附近的敌人, 掉落物和弹幕"}, --  Ocular Rift
	[607] = {"607", "脓液囊宝宝", "向四周随机喷射泪弹#泪弹造成3.5或5.25点伤害"}, --  Boiled Baby
	[608] = {"608", "冰冻宝宝", "{{Petrify}} 发射石化泪弹, 造成3.5点伤害#{{Freezing}} 击杀时使敌人冻结"}, --  Freezer Baby
	[609] = {"609", "永恒六面骰", "重置房间中所有道具#25%概率删除道具而不是重置"}, --  Eternal D6
	[610] = {"610", "鸟肥笼", "角色在房间中首次受伤时, 跃向敌人#造成45点伤害并释放岩石波#之后追击敌人, 每秒造成6.5点接触伤害"}, --  Bird Cage
	[611] = {"611", "声带", "角色怒吼, 击退周围的敌人并造成伤害#充能越多, 怒吼效果越强"}, --  Larynx
	[612] = {"612", "迷失游魂", "受伤时时死亡, 会在下一层重生#如果存活时带到下一层, 生成:#{{SoulHeart}} 3魂心#{{EternalHeart}} 2永恒之心#{{TreasureRoom}} 1个宝箱房道具#{{AngelRoom}} 1个天使房道具"}, --  Lost Soul
	[613] = {"613", "", "<道具不存在>"},
	[614] = {"614", "鲜血炸弹", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗5红心#{{HalfHeart}} 若角色没有炸弹, 则可以花费半红心放置炸弹#角色的炸弹会留下血迹"}, --  Blood Bombs
	[615] = {"615", "屁球宝宝", "角色即将受伤时, 弹开敌人或弹幕#概率反弹其周围的弹幕#弹开后需要触碰才能再次激活"}, --  Lil Dumpy
	[616] = {"616", "鸟眼椒", "8%概率发射红火, 阻挡敌人弹幕并造成接触伤害#{{Luck}} 幸运11: 50%概率#火焰造成或阻挡4次伤害后或10秒后消失"}, --  Bird's Eye
	[617] = {"617", "磁石", "{{Magnetize}} 17%概率发射使敌人磁化的泪弹#{{Luck}} 运气5: 100%概率#磁化的敌人吸引掉落物, 弹幕和其它敌人"}, --  Lodestone
	[618] = {"618", "烂番茄", "{{Bait}} 17%概率发射标记敌人的泪弹#{{Luck}} 运气5: 100%概率#被标记的敌人会被其他敌人攻击"}, --  Rotten Tomato
	[619] = {"619", "长子名分", "不同角色效果不同"}, --  Birthright
	[620] = {"620", "", "<道具不存在>"},
	[621] = {"621", "红豆汤", "↑ {{Damage}} 伤害+21.6#{{HealingRed}} 回满血#增加的伤害在3分钟内会不断衰减#效果尚存时击杀敌人会延长时间"}, --  Red Stew
	[622] = {"622", "创世记", "移除角色的所有道具和掉落物#将角色传送至特殊的卧室, 内有掉落物和箱子#每移除1个道具, 角色就可从来自相同道具池的3个道具选择#离开卧室时, 将角色带到下一层"}, --  Genesis
	[623] = {"623", "尖头钥匙", "{{Key}} +5钥匙#向角色发射方向投掷角色的1钥匙#投掷的钥匙可造成伤害, 摧毁障碍物或开门#被钥匙击杀的敌人有概率掉落箱子里的物品, 包括道具"}, --  Sharp Key
	[624] = {"624", "扩展包", "{{Card}} 生成5随机卡牌"}, --  Booster Pack
	[625] = {"625", "超级蘑菇", "{{Timer}} 角色巨化并获得:#↑ {{Damage}} 伤害修正x4#↑ {{Range}} 射程+2#↓ {{Tears}} 射速-1.9#无敌#能踩碎障碍物和敌人#{{Timer}} 持续30秒, 能在房间之间和层之间持续"}, --  Mega Mush
	[626] = {"626", "菜刀碎片1", "与{{Collectible627}}菜刀碎片2结合变为可投掷的菜刀, 造成25点伤害#菜刀能打开红色肉门"}, --  Knife Piece 1
	[627] = {"627", "菜刀碎片2", "与{{Collectible626}}菜刀碎片1结合变为可投掷的菜刀, 造成25点伤害#菜刀能打开红色肉门"}, --  Knife Piece 2
	[628] = {"628", "死亡证明", "将角色传送至含有所有游戏道具的一层#拾起1个道具后回到之前的房间"}, --  Death Certificate
	[629] = {"629", "机器苍蝇", "发射能摧毁敌人弹幕的护盾泪弹#每秒造成3点接触伤害"}, --  Bot Fly
	[630] = {"630", "", "<道具不存在>"},
	[631] = {"631", "切肉刀", "使敌人分裂为2个40%血量的小型版本#本身能分裂的敌人(比如嫉妒)改为造成分裂所需的伤害#对无法分裂的敌人造成25点伤害"}, --  Meat Cleaver
	[632] = {"632", "邪眼护符", "↑ {{Luck}} 幸运+2#免疫{{Burning}}烧伤, {{Confusion}}混乱, {{Fear}}恐惧, {{Poison}}毒气效果"}, --  Evil Charm
	[633] = {"633", "教条", "↑ {{Speed}} 移速+0.1#↑ {{Damage}} 伤害+2#飞行, 单次{{Collectible313}}神圣屏障护盾#{{Heart}} 若角色少于6心, 则以红心和魂心治疗至6心"}, --  Dogma
	[634] = {"634", "炼狱恶鬼", "在有敌人的房间中的地面生成红色裂缝#走过裂缝时会召唤追踪爆炸幽灵"}, --  Purgatory
	[635] = {"635", "织布魔偶", "生成1个跟班, 向角色发射方向移动#使用时, 角色与跟班互换位置, 并短暂无敌#传送到物体上可以造成伤害或将其摧毁"}, --  Stitches
	[636] = {"636", "R键", "整局重新开始#已收集的道具, 饰品, 属性和掉落物保留#计时器不重置"}, --  R Key
	[637] = {"637", "强力安眠药", "{{Confusion}} 10%概率发射拳头, 对敌人造成强力击退和混乱#{{Luck}} 运气9: 100%概率#撞到墙/障碍物的敌人会受到伤害"}, --  Knockout Drops
	[638] = {"638", "橡皮擦", "掷出橡皮, 秒杀击中的敌人#击杀的敌人在本局游戏中不会再出现#对头目造成15点伤害#每层只能使用一次"}, --  Eraser
	[639] = {"639", "难吃的心", "{{RottenHeart}} +1腐心"}, --  Yuck Heart
	[640] = {"640", "灵魂之瓮", "喷射火焰#击杀1个敌人, 瓮增加1格充能"}, --  Urn of Souls
	[641] = {"641", "血田", "在有敌人的房间中, 在角色身后产生一串泪弹#泪弹造成3.5点伤害"}, --  Akeldama
	[642] = {"642", "玄奇驴皮", "生成当前房间道具池的1个道具#将1心之容器/1骨心/2魂心变为1碎心#生成当前房间道具池的1个道具#{{Warning}} 若角色不再持有, 则有概率将后续道具替换{{ColorSilver}}(1次使用后33%, 2次后50%, 3次后100%)#若玄奇驴皮在本层道具底座上, 则降低概率"}, --  Magic Skin
	[643] = {"643", "终末天启", "{{SoulHeart}} +2魂心#飞行#{{Chargeable}} 可蓄力发射高伤害圣光柱#不会取代角色的泪弹"}, --  Revelation
	[644] = {"644", "安慰奖", "↑ 提升角色速度/射速/伤害/射程中最低的属性#根据角色持有的最少掉落物, 生成3{{Coin}}硬币/1{{Bomb}}炸弹/1{{Key}}钥匙"}, --  Consolation Prize
	[645] = {"645", "小畸胎瘤", "阻挡弹幕的大型环绕物#每秒造成3.5点接触伤害#受击3次时, 分裂为更小的畸胎瘤#小畸胎瘤被摧毁时产生蓝蜘蛛#被完全摧毁时, 5秒后重生"}, --  Tinytoma
	[646] = {"646", "硫磺火炸弹", "{{Bomb}} +5炸弹#{{Collectible118}} 角色的炸弹爆炸时, 释放十字血柱#血柱不会伤到角色"}, --  Brimstone Bombs
	[647] = {"647", "4.5伏特", "清理房间不再对主动道具充能#对敌人造成伤害时缓慢充能#充能所需伤害量随层数提升"}, --  4.5 Volt
	[648] = {"648", "", "<道具不存在>"},
	[649] = {"649", "甜甜糖梅宝", "在房间中斜角前进, 向路径上发射泪弹, 造成3点伤害#每秒造成6点接触伤害"}, --  Fruity Plum
	[650] = {"650", "糖梅溜溜笛", "{{Timer}} 在当前房间中召唤1只友好的糖梅宝宝, 持续10秒"}, --  Plum Flute
	[651] = {"651", "伯列恒之星", "从本层初始房间向{{BossRoom}}头目房缓慢移动#角色领先则移动加快, 角色落后则移动减慢#站在光环中获得:#↑ {{Tears}} 射速修正x2.5#↑ {{Damage}} 伤害修正x1.8#追踪泪弹#50%概率忽略伤害"}, --  Star of Bethlehem
	[652] = {"652", "冰块宝宝", "经过时可踢开#{{Slow}} 使敌人减速, 根据速度造成最多17.5点接触伤害#{{Freezing}} 击杀时使敌人冻结"}, --  Cube Baby
	[653] = {"653", "驱魔护符", "持有时, 非幽灵的敌人在死亡时生成小的红色幽灵#使用时, 引爆所有红色幽灵#使用时, 也会击杀所有血量低于50%的幽灵类敌人(包括头目)"}, --  Vade Retro
	[654] = {"654", "伪造药学博士证", "{{BlackHeart}} +1黑心#{{Pill}} 识别所有胶囊#{{Pill}} 好胶囊变为坏的#↑ {{Damage}} 吃降低属性的胶囊, 伤害+0.6#{{BlackHeart}} 吃其它坏胶囊, 生成1黑心"}, --  False PHD
	[655] = {"655", "幸运转盘", "获得1个陀螺环绕物, 阻挡敌人弹幕, 每秒造成10.5点接触伤害#↑ 使用时获得:#↑ {{Speed}} 移速+0.5#提升环绕物的速度和伤害"}, --  Spin to Win
	[656] = {"656", "达摩克里斯之剑", "在角色头上悬着剑, 并使底座道具翻倍#有价格或箱子中的道具不翻倍#{{Warning}} 受伤后, 剑每帧有极低概率立即击杀角色#无敌效果可以避免死亡"}, -- Damocles
	[657] = {"657", "血管炎", "敌人死亡时爆出泪弹, 继承角色的泪弹效果"}, --  Vasculitis
	[658] = {"658", "巨细胞", "受伤时生成小以撒#小以撒追击附近敌人并向其发射"}, --  Giant Cell
	[659] = {"659", "托吡卡胺", "↑ {{Range}} 射程+2.5#↑ {{Tearsize}} 泪弹尺寸+0.22"}, --  Tropicamide
	[660] = {"660", "牌意解读", "在每层的初始房间中生成2个传送门#离开房间时传送门消失#{{Blank}} {{ColorRed}}红色: {{CR}}头目房#{{Blank}} {{ColorYellow}}黄色: {{CR}}{{TreasureRoom}} 宝箱房#{{Blank}} {{ColorBlue}}蓝色: {{CR}}{{SecretRoom}} 隐藏房"}, --  Card Reading
	[661] = {"661", "五胞胎", "敌人死亡处生成1个不动跟班#最多5个跟班"}, --  Quints
	[662] = {"662", "", "<道具不存在>"}, -- Pacifist (Cut item)
	[663] = {"663", "肉中刺", "每6秒获得1秒无敌#效果触发前角色会闪光"}, --  Tooth and Nail
	[664] = {"664", "大胃王", "↑ {{Heart}} +1心之容器#{{HealingRed}} 回满血#所有底座道具会周期性地切换为食物道具#拾起食物道具时获得:#{{HealingRed}} 额外治疗1红心#↑ {{Damage}} 暂时伤害+3.6#↑ 永久提升2项属性(取决于食物)#↓ {{Speed}} 永久移速-0.03"}, --  Binge Eater
	[665] = {"665", "嗝屁猫的眼睛", "在打开或摧毁前, 揭示{{Chest}}箱子, {{GrabBag}}福袋, 店主, 火堆的内容"}, --  Guppy's Eye
	[666] = {"666", "", "<道具不存在>"},
	[667] = {"667", "稻草人", "{{Bomb}} +1炸弹#{{Player14}} 生成店主作为第二个角色#店主死亡时生成蓝蜘蛛并永久移除稻草人及其拾起的道具#{{DevilChance}} 店主活着时恶魔交易花费硬币#{{Warning}} 店主也能拾起剧情道具"}, --  Strawman
	[668] = {"668", "爸爸的便条", "开始回溯#之前留在{{TreasureRoom}}宝箱房或{{BossRoom}}头目房的饰品会变成{{Card78}}红钥匙碎片"}, --  Dad's Note
	[669] = {"669", "腊肠", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.2#↑ {{Tears}} 射速+0.5#↑ {{Damage}} 伤害+0.5#↑ {{Range}} 射程+2.5#↑ {{Shotspeed}} 弹速+0.16#↑ {{Luck}} 幸运+1#{{HealingRed}} 回满血#{{AngelDevilChance}} 恶魔房/天使房概率+6.9%#{{Planetarium}} 星象房概率+6.9%"}, --  Sausage
	[670] = {"670", "选择？", "允许角色从两个不同的房间清理奖励中选择"}, --  Options?
	[671] = {"671", "糖心", "↑ 用{{Heart}}红心治疗时, 永久获得随机属性提升#{{Heart}} 生成1红心"}, --  Candy Heart
	[672] = {"672", "一磅肉", "{{DevilChance}} 恶魔交易消耗硬币#{{Shop}} 商店道具花费心之容器#{{Shop}} 商店消耗品被尖刺环绕"}, --  A Pound of Flesh
	[673] = {"673", "赎罪", "{{DevilChance}} 进入恶魔房且不拿任何道具/掉落物后, 进入新层获得:#↑ {{Damage}} 伤害+1#{{SoulHeart}} +1魂心"}, --  Redemption
	[674] = {"674", "灵魂枷锁", "承受致命伤害时, 将角色变为幽灵并被锁链束缚在尸体上, 留有半心继续战斗#幽灵存活10秒后, 角色重生#必须通过拾起魂心充能"}, --  Spirit Shackles
	[675] = {"675", "碎裂的宝珠", "受伤时:#打开房间中所有上锁的门#揭示地图上1个随机房间#摧毁所有标记石头和暗门石头"}, --  Cracked Orb
	[676] = {"676", "空虚之心", "{{EmptyHeart}} 当不多于1红心开始新层时, +1空心之容器"}, --  Empty Heart
	[677] = {"677", "灵魂出窍", "{{Timer}} 在有敌人的房间中首次受伤时, 获得:#灵体泪弹#飞行#抵消下次伤害#时间暂停2秒#2秒内逐渐提升移速和射速"}, --  Astral Projection
	[678] = {"678", "剖腹产", "{{Chargeable}} 角色的泪弹由蓄力攻击取代, 发射追踪灵体胎儿#{{Damage}} 胎儿每秒造成2.8x角色伤害"}, --  C Section
	[679] = {"679", "亚巴顿宝宝", "{{Collectible399}} 蓄力并发射虚空之喉进行攻击的跟班#1秒内造成52.5点伤害"}, --  Lil Abaddon
	[680] = {"680", "水土不服症", "{{Chargeable}} 蓄力后方发射短程高伤害光柱#不取代角色泪弹"}, --  Montezuma's Revenge
	[681] = {"681", "黑洞宝宝", "向前飞行并造成接触伤害#飞行时吸收掉落物#每吸收1个都增加其体积和伤害, 并生成1只蓝苍蝇#每吸收4个, 生成1个通向未探索房间的传送门"}, --  Lil Portal
	[682] = {"682", "触手朋友", "有时会从地面伸出一条触手束缚敌人#受缚的敌人每秒受到8点伤害, 减速并无法移动"}, --  Worm Friend
	[683] = {"683", "骨刺", "敌人死亡时生成骨片#骨片可阻挡弹幕并造成接触伤害"}, --  Bone Spurs
	[684] = {"684", "饥饿幽魂", "击杀敌人时, 33%概率生成幽灵#幽灵追击敌人, 造成接触伤害并在5秒后爆炸#角色不受该爆炸伤害"}, --  Hungry Soul
	[685] = {"685", "魂火罐", "生成1随机魂火#每次使用多生成1魂火, 最多12个"}, --  Jar of Wisps
	[686] = {"686", "灵魂吊坠", "↑ 拾起{{SoulHeart}}魂心时, 永久获得随机属性提升#{{SoulHeart}} 生成1魂心"}, --  Soul Locket
	[687] = {"687", "寻友护符", "{{Friendly}} 生成1个友好的敌人, 并模拟角色移动和攻击"}, --  Friend Finder
	[688] = {"688", "内在孩童", "+1生命#死亡时:#角色在相同房间以半心重生#↑ {{Speed}} 移速+0.2#↑ 体型大幅变小"}, --  Inner Child
	[689] = {"689", "错误王冠", "底座道具在5个随机道具之间快速切换"}, --  Glitched Crown
	[690] = {"690", "肚肚软糖", "敌人能被角色弹开#50%概率抵消接触伤害#50%概率反弹敌人弹幕"}, --  Belly Jelly
	[691] = {"691", "十字圣球", "阻止品质为{{Quality0}}/{{Quality1}}的道具生成#33%概率重置品质为{{Quality2}}的道具"}, --  Sacred Orb
	[692] = {"692", "血色羁绊", "在{{DevilRoom}}恶魔房中生成地刺#在地刺上受伤可获得:#35%: 无#33%: ↑ {{Damage}} 伤害+0.5#15%: 6{{Coin}}硬币#10%: 2{{BlackHeart}}黑心#5%: 随机{{DevilRoom}}恶魔房道具#2%: {{Leviathan}}利维坦套装"}, --  Sanguine Bond
	[693] = {"693", "虫群", "获得8只环绕苍蝇#清理房间后, 生成1只新苍蝇#阻挡弹幕后, 苍蝇变成蓝苍蝇"}, --  The Swarm
	[694] = {"694", "心碎", "↑ {{Damage}} 每个碎心+0.25伤害#{{BrokenHeart}} +3碎心#{{BrokenHeart}} 致死时, 致死伤害改为+2碎心#{{Warning}} 角色12碎心时死亡"}, --  Heartbreak
	[695] = {"695", "嗜血腥风", "受伤时, 在本层获得:#↑ {{Speed}} 移速提升#↑ {{Tears}} 射速提升#最多移速+1.02, 射速+3"}, --  Bloody Gust
	[696] = {"696", "救恩", "角色周围环绕光环#站在光环中过久的敌人受到十字光柱攻击#受伤时, 在本层中提升光环的大小"}, --  Salvation
	[697] = {"697", "消失的胞胎", "进入头目房时, 生成头目的复制体#击败复制体可额外生成1个道具#复制体更慢, 血量只有75%"}, --  Vanishing Twin
	[698] = {"698", "作孽双子", "发射与角色相同属性和效果泪弹的2个跟班#{{Damage}} 造成0.375x角色伤害"}, --  Twisted Pair
	[699] = {"699", "阿撒泻勒之怒", "{{Collectible118}} 清理4个房间后, 进入新房间时, 发射大型硫磺火激光"}, --  Azazel's Rage
	[700] = {"700", "回声室", "使用{{Rune}}符文/{{Card}}卡牌/{{Pill}}胶囊时, 也使用在拾起回声室之后使用的最近3个符文/卡牌/胶囊"}, --  Echo Chamber
	[701] = {"701", "以撒的坟墓", "每层开始时生成1{{DirtyChest}}旧箱子#旧箱子需要1钥匙打开, 含有{{SoulHeart}}魂心/{{Trinket}}饰品/{{AngelRoom}}天使房道具/妈妈, 爸爸相关的道具"}, --  Isaac's Tomb
	[702] = {"702", "复仇之魂", "受伤时, 生成1环绕魂火#魂火发射泪弹, 不阻挡弹幕, 下一层消失#最多6魂火"}, --  Vengeful Spirit
	[703] = {"703", "小以扫", "在当前角色和小以扫之间切换#小以扫拥有3黑心, {{Damage}}伤害+2, 飞行, 首次使用时获得与主角色等量的随机道具#两个角色道具和血量独立#{{Warning}} 任意角色死亡, 游戏结束"}, --  Esau Jr.
	[704] = {"704", "狂怒！", "{{Battery}} 造成伤害时充能#{{Timer}} 5秒内获得:#↑ {{Speed}} 移速+0.4#↑ {{Tears}} 射速修正x0.5#↑ {{Tears}} 射速+2#↑ {{Damage}} 伤害+3#只能使用特定近战武器, 能反弹弹幕#{{Timer}} 击杀敌人可延长此状态1秒, 并获得短暂无敌"}, --  Berserk!
	[705] = {"705", "暗仪刺刀", "{{Timer}} 1秒内(发射前)获得:#↑ 移速+1#角色可穿过敌人/弹幕并使其静止#效果结束时, 伤害静止的敌人, 移除静止的弹幕, 在角色位置产生冲击#穿过的敌人/弹幕越多, 伤害和冲击越强"}, --  Dark Arts
	[706] = {"706", "无底坑", "消耗房间中所有底座道具并对应生成蝗虫跟班#蝗虫造成2x-3x角色伤害#一些道具会生成特殊蝗虫"}, --  Abyss
	[707] = {"707", "晚餐", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心"}, --  Supper
	[708] = {"708", "订书机", "↑ {{Damage}} 伤害+1#角色所有泪弹都从右眼发射"}, --  Stapler
	[709] = {"709", "背摔！", "角色向移动方向冲刺#冲到敌人或头目时将其举起并摔在地上#根据角色体型造成摔伤并产生岩石波#冲刺和摔击时角色无敌"}, --  Suplex!
	[710] = {"710", "合成宝袋", "收集最多8个掉落物, 不能再拿出#集满时使用可将掉落物合成为道具#道具品质取决于掉落物品质"}, --  Bag of Crafting
	[711] = {"711", "生死逆转", "进入有底座道具的房间时, 在底座上显示另一个虚道具#使用时, 调换虚实道具位置#在拿走第一个道具后使用生死逆转时, 允许角色拾起另一个#{{Warning}} 单独的虚道具在离开房间后消失"}, --  Flip
	[712] = {"712", "所罗门魔典", "生成1个环绕物, 获得随机道具的效果#该道具由25%概率来自当前房间的道具池, 75%概率来自宝箱房/头目房/商店道具池"}, --  Lemegeton
	[713] = {"713", "圣血吸管", "移除半心并创造1个血团#血团复制角色的泪弹#不同类型的心产生不同血量, 伤害和泪弹效果的血团"}, --  Sumptorium
	[714] = {"714", "召回", "从任意距离召回遗骸的身体#遗骸之魂在遗骸返回时无敌"}, --  Recall
	[715] = {"715", "保留", "若未存有大便, 则将下一个大便存入#若存有大便, 则使用该大便"}, --  Hold
	[716] = {"716", "店主的胯袋", "拾起时, 生成3{{Coin}}硬币和1{{Key}}钥匙#{{Shop}} 每花费3硬币获得其一:#↑ {{Speed}} +0.03移速#↑ {{Damage}} 伤害+0.5#↑ {{Range}} 射程+0.25"}, --  Keeper's Sack
	[717] = {"717", "店主的亲友", "石头和障碍物在被摧毁时生成2只蓝蜘蛛#石头在有敌人的房间中时不时会产生蓝蜘蛛"}, --  Keeper's Kin
	[718] = {"718", "", "<道具不存在>"}, -- Keepers Robe (Cut item)
	[719] = {"719", "店主的盒子", "{{Shop}} 生成1个可购买的商店道具/掉落物"}, --  Keeper's Box
	[720] = {"720", "百宝罐", "根据充能量生成掉落物#充能奖励:#{{Blank}} 1:大便 2:{{Coin}} 3:{{Bomb}} 4:{{Key}}#{{Blank}} 5:{{Heart}} 6:{{Pill}} 7:{{Card}} 8:{{SoulHeart}}#{{Blank}} 9:{{GoldenHeart}} 10:{{GoldenKey}} 11:{{GoldenBomb}}#{{Blank}} 12充能时触发一个随机强力效果"}, --  Everything Jar
	[721] = {"721", "错误技", "使后续道具都为错误道具#错误道具的效果完全随机"}, --  TMTRAINER
	[722] = {"722", "孤魂铁索", "{{Chained}} 禁锢离角色最近的敌人5秒#被禁锢的敌人无法移动或攻击"}, --  Anima Sola
	[723] = {"723", "计数二十面骰", "将房间中所有道具重置为内部ID减1的道具"}, --  Spindown Dice
	[724] = {"724", "高凝血", "{{Heart}} 受伤时, 根据受伤量掉落半红心或整红心#产生的红心弹出并在1.5秒后消失"}, --  Hypercoagulation
	[725] = {"725", "大肠激躁症", "造成足够伤害使角色闪红色#闪红时松开发射键, 触发其一:#投掷1个随机大便#产生增益水迹#放毒屁#生成5个激活的炸弹"}, --  IBS
	[726] = {"726", "咯血症", "双击发射键使角色咯血#咯血造成1.5x角色伤害#1秒冷却#{{BrimstoneCurse}} 硫磺火激光对受影响的敌人造成额外伤害"}, --  Hemoptysis
	[727] = {"727", "幽灵炸弹", "{{Bomb}} +5炸弹#爆炸时生成幽灵追击敌人#幽灵每秒造成2x角色伤害, 并在10秒后爆炸"}, --  Ghost Bombs
	[728] = {"728", "格罗", "在当前房间中, 角色会迸出恶魔跟班#恶魔向最近的敌人发射, 模仿角色属性和泪弹效果#{{Damage}} 其泪弹造成0.75x角色伤害"}, --  Gello
	[729] = {"729", "飞头攻击", "向一方向投掷角色的头#头造成接触伤害, 在落点发射泪弹#再次使用或接触时, 将头收回"}, --  Decap Attack
	[730] = {"730", "玻璃眼", "↑ {{Damage}} 伤害+0.75#↑ {{Luck}} 幸运+1"}, -- Glass Eye
	[731] = {"731", "麦粒肿", "↑ {{Damage}} 右眼伤害修正x1.28#↑ {{Range}} 右眼射程+6.5#↓ {{Shotspeed}} 右眼弹速-0.3"}, --  Stye
	[732] = {"732", "妈妈的戒指", "↑ {{Damage}} 伤害+1#{{Rune}} 生成1随机符文/魂石"}, --  Mom's Ring
}
EID:updateDescriptionsViaTable(repCollectibles, EID.descriptions[languageCode].collectibles)

---------- Modifiers ----------

-- Buffs caused by Binge Eater
-- Note: "#" will be replaced with "#{{Collectible664}} " automatically, in order to add Binge eater icon infront of each buff-bulletpoint
EID.descriptions[languageCode].bingeEaterBuffs = {
	[22] = "↑ {{Tears}} 射速+0.5#↑ {{Range}} 射程+2.5#↑ {{Damage}} 暂时伤害+3.6#↓ {{Speed}} 移速-0.03", -- Lunch
	[23] = "↑ {{Tears}} 射速+0.5#↑ {{Shotspeed}} 弹速+0.2#↑ {{Damage}} 暂时伤害+3.6#↓ {{Speed}} 移速-0.03", -- Dinner
	[24] = "↑ {{Damage}} 伤害+1#↑ {{Shotspeed}} 弹速+0.2#↑ {{Damage}} 暂时伤害+3.6#↓ {{Speed}} 移速-0.03", -- Dessert
	[25] = "↑ {{Range}} 射程+2.5#↑ {{Shotspeed}} 弹速+0.2#↑ {{Damage}} 暂时伤害+3.6#↓ {{Speed}} 移速-0.03", -- Breakfast
	[26] = "↑ {{Damage}} 伤害+1#↑ {{Range}} +2.5射程#↑ {{Damage}} 暂时伤害+3.6#↓ {{Speed}} 移速-0.03", -- Rotten Meat
	[346] = "↑ {{Shotspeed}} 弹速+0.2#↑ {{Luck}}  幸运+1#↑ {{Damage}} 暂时伤害+3.6#↓ {{Speed}} 移速-0.03", -- A Snack
	[456] = "↑ {{Damage}} 伤害+1#↑ {{Luck}} 幸运+1#↑ {{Damage}} 暂时伤害+3.6#↓ {{Speed}} 移速-0.03", -- Midnight Snack
	[707] = "↑ {{Tears}} 射速+0.5#↑ {{Luck}}  幸运+1#↑ {{Damage}} 暂时伤害+3.6#↓ {{Speed}} 移速-0.03", -- Supper
}

-- Buffs caused by Book of Belial with Judas' Birthright
-- Note: "#" will be replaced with "#{{Collectible34}} " automatically, in order to add Book of Belial icon infront of each buff-bulletpoint
EID.descriptions[languageCode].bookOfBelialBuffs = {
	[40] = "同时产生{{Collectible35}}死灵之书的效果", -- Kamikaze!
	[126] = "同时产生{{Collectible35}}死灵之书的效果", -- Razor Blade
	[127] = "↑ {{Damage}} 下一层伤害+2", -- Forget me Now
	[133] = "↑ {{Damage}} 伤害+0.5", -- Guppy's Paw
	[135] = "每次使用↑ {{Damage}} 暂时伤害+0.66", -- IV Bag
	[147] = "铁镐耐久和击退力提高, 使用速度更快, 使敌人{{Burning}}燃烧, 摧毁大便和障碍物时掉落更多掉落物", -- Notched Axe
	[186] = "同时产生{{Collectible126}}剃刀片的效果", -- Blood Rights
	[282] = "留下一路火焰, 能造成接触伤害并使敌人{{Burning}}燃烧", -- How to Jump
	[290] = "一次消耗1心, 获得{{Damage}}伤害提升并在地上留下血迹", -- The Jar
	[295] = "有概率产生{{Collectible555}}金剃刀片的效果", -- Magic Fingers
	[297] = "除正常奖励外, 还永久获得1个恶魔类跟班", -- Pandora's Box
	[323] = "改为10颗穿刺灵体泪弹, 具有伤害加成", -- Isaac's Tears
	[326] = "无敌时, 生成光柱由火焰光环取代#完美阻挡时, 暂时{{Damage}}伤害提升并产生{{Collectible35}}死灵之书的效果", -- Breath of Life
	[352] = "破碎时激活{{Collectible34}}彼列之书#伤害提升在大炮修复完之前保留", -- Glass Cannon
	[475] = "若能重生, 重生为犹大之影", -- Plan C
	[482] = "将最后获得的道具换成{{Collectible51}}五芒星", -- Clicker
	[487] = "↑ {{Damage}} 伤害额外+0.5", -- Potato Peeler
	[536] = "对于每个献祭的跟班:#↑ {{Damage}} 伤害+10.8, 该伤害提升缓慢流逝", -- Sacrificial Altar
	[555] = "对房间中的所有敌人造成伤害#由此击杀的敌人可能掉落1-2硬币", -- Golden Razor
	[577] = "↑ {{Damage}} 伤害永久提升", -- Damocles
	[582] = "↑ {{Damage}} 伤害根据道具效果最大叠加次数在本层永久提升", -- Wavy Cap
	[585] = "将奖励改为2黑心和1个恶魔房道具#若进行过恶魔交易, 则改为3黑心和2个恶魔房道具", -- Alabaster Box
	[622] = "获得免费的{{Collectible51}}五芒星", -- Genesis
	[623] = "同时产生{{Collectible126}}剃刀片的效果", -- Sharp Key
	[635] = "在角色和织布魔偶之间产生1个{{Collectible705}}暗仪刺刀", -- Stitches
	[640] = "改为发射{{Collectible118}}硫磺火", -- Urn of Souls
	[642] = "↑ {{Damage}} 伤害修正x1.4#↑ {{Damage}} 伤害+1", -- Magic Skin
	[653] = "幽灵追踪敌人", -- Vade Retro
	[685] = "生成{{Collectible292}}撒但圣经魂火#{{DevilChance}} 每有1该魂火, 恶魔房概率+10%", -- Jar of Wisps
	[705] = "对于击中的每个敌人/弹幕↑ {{Damage}} 暂时伤害提升", -- Dark Arts
	[710] = "拾起{{Heart}}红心时, 概率将其替换成{{BlackHeart}}黑心", -- Bag of Crafting
	[729] = "当头分离时:#↑ {{Tears}} 泪速修正x3#↑ {{Damage}} 伤害+2", -- Decap Attack
}

-- Book of Virtues wisp types
EID.descriptions[languageCode].BookOfVirtuesWispTexts = {
	-- values inside {} brackets will be replaced with text parts below
	-- Wisp texts are affected by the PluralizeFunction (ab+ file)
	-- The placeholder therefore can be used in all parts that make up the wisp descriptions
	StatDescription = "{ringIcon}{{Wisp}} {amount}|{{Heart}} {health}|{{Damage}} {damage}",	-- {ringIcon} will be replaced with an icon representing the wisp movement, {amount} with the number of wisps, {health} with the HP, {damage} with the damage or the "CantShoot" text
	Shotspeed = "{1}%弹速", 				-- {1} will be replaced with the shot speed changes in %
	Chance = " ({1}%概率)",					-- {1} will be replaced with the chance
	SingleRoom = "单房间魂火",
	NoWisps = "无魂火",
}

-- Book of Virtues wisp types
EID.descriptions[languageCode].bookOfVirtuesWisps = {
	[35] = "{{Collectible35}} 被摧毁时触发死灵之书的效果", -- The Necronomicon
	[37] = "被摧毁时生成分裂追踪炸弹", -- Mr. Boom
	[38] = "不精准泪弹", -- Tammy's Head
	[40] = "被摧毁时爆炸", -- Kamikaze!
	[47] = "向准星发射3颗爆炸泪弹", -- Doctor's Remote
	[49] = "使用时发射激光", -- Shoop da Whoop!
	[56] = "魂火会滴落黄色水迹", -- Lemon Mishap
	[58] = "免疫弹幕#{{Collectible58}}的效果期间免疫伤害", -- Book of Shadows
	[65] = "被摧毁时掉落1个即爆炸弹", -- Anarchist Cookbook
	[66] = "{{Slow}}被摧毁时使敌人减速3秒", -- The Hourglass
	[77] = "额外接触伤害", -- My Little Unicorn
	[78] = "被摧毁时在当前房间中生成1只蝗虫", -- Book of Revelations
	[85] = "被摧毁时掉落1{{Card}}卡牌", -- Deck of Cards
	[97] = "8选1生成魂火:#{{Collectible65}}{{Collectible42}}{{Collectible85}}{{Collectible102}}{{Collectible37}}{{Collectible177}}{{Collectible49}}{{Collectible45}}#{{Warning}} 很有可能为爆炸效果", -- The Book of Sin
	[102] = "6选1生成魂火:#普通泪弹且被摧毁时生成1只红蜘蛛/中毒泪弹/石化泪弹/迷惑泪弹/烧伤泪弹/即爆炸弹泪弹#无论哪种, 被摧毁时生成1胶囊", -- Mom's Bottle of Pills
	[105] = "每重置1个道具额外生成1魂火", -- The D6
	[111] = "{{Poison}}被摧毁时产生毒气", -- The Bean
	[123] = "随机泪弹", -- Monster Manual
	[124] = "生成触发道具对应的魂火", -- Dead Sea Scrolls
	[127] = "仅存在于道具所创新层的无限血量魂火", -- Forget Me Now
	[130] = "魂火会向角色发射方向冲刺", -- A Pony
	[133] = "生成3高血量魂火", -- Guppy's Paw
	[137] = "每个引爆的炸弹生成1魂火#魂火的泪弹也可以被远程引爆", -- Remote Detonator
	[145] = "生成魂火而不是苍蝇#被摧毁时生成1只蓝苍蝇", -- Guppy's Head
	[147] = "概率从大便生成粪滴魂火, 从石头5选1生成魂火:#{{Collectible132}}煤炭/{{Collectible201}}铁/{{Collectible202}}金/{{Collectible68}}红石/{{Collectible415}}钻石", -- Notched Axe
	[160] = "接触时召唤光束", -- Crack the Sky
	[166] = "摧毁房间中所有掉落物, 每个都有概率生成1魂火", -- D20
	[175] = "魂火会解锁碰到的箱子/门, 包括超级撒但, 回溯, 尸宫的门#该魂火可以捐给{{KeyBeggar}}钥匙大师", -- Dad's Key
	[177] = "根据获得的奖励生成魂火", -- Portable Slot
	[181] = "10%概率发射{{Collectible374}}圣光泪弹", -- White Pony
	[186] = "高血量魂火", -- Blood Rights
	[192] = "追踪泪弹", -- Telepathy for Dummies
	[263] = "被摧毁时掉落1{{Rune}}符文", -- Clear Rune
	[283] = "重置所有魂火并生成1随机魂火#不重置美德之书", -- D100
	[284] = "移除所有魂火, 每持有2个道具生成1随机魂火#不重置美德之书", -- D4
	[285] = "10%概率发射十面骰效果的泪弹", -- D10
	[286] = "被摧毁时掉落1{{Card}}卡牌", -- Blank Card
	[287] = "{{Collectible675}}被摧毁时产生碎裂的宝珠的效果", -- Book of Secrets
	[288] = "生成魂火而不是蜘蛛#被摧毁时生成1蓝蜘蛛", -- Box of Spiders
	[289] = "红火泪弹", -- Red Candle
	[290] = "生成魂火而不是掉落红心#被摧毁时概率生成1{{HalfHeart}}半红心", -- The Jar
	[291] = "每有1个被冲走的敌人额外生成1魂火", -- Flush!
	[292] = "每有1撒但圣经魂火,{{AngelDevilChance}}恶魔房/天使房概率+10%", -- Satanic Bible
	[293] = "被摧毁时发射4向{{Collectible118}}硫磺火激光", -- Head of Krampus
	[294] = "被摧毁时产生棉豆的效果", -- Butter Bean
	[295] = "被摧毁时概率掉落1{{Coin}}硬币", -- Magic Fingers
	[296] = "较高血量魂火, 可以用{{Heart}}红心治疗", -- Converter
	[297] = "根据当前层生成0-8魂火", -- Pandora's Box
	[298] = "免疫接触伤害#只有激活独角兽的残角或类似效果时才会造成接触伤害", -- Unicorn Stump
	[323] = "只能维持3秒", -- Isaac's Tears
	[324] = "{{Collectible570}}黏土饼干泪弹", -- Undefined
	[325] = "抛射泪弹", -- Scissors
	[326] = "完美阻挡时生成4魂火", -- Breath of Life
	[347] = "{{Collectible245}}完美视力泪弹#复制所有其他魂火", -- Diplopia
	[348] = "被摧毁时生成1{{Pill}}胶囊", -- Placebo
	[349] = "被摧毁时50%概率掉落1{{Coin}}硬币", -- Wooden Nickel
	[351] = "使用时产生岩石波#被摧毁时{{Petrify}}石化敌人并产生{{Poison}}毒气", -- Mega Bean
	[352] = "被摧毁时, 摧毁所有玻璃大炮魂火", -- Glass Cannon
	[357] = "复制房间中所有魂火", -- Box of Friends
	[382] = "友好敌人死亡时, 根据其攻击方式, 生成发射普通/追踪/爆炸/硫磺火泪弹的1魂火", -- Friendly Ball
	[383] = "魂火的泪弹可以被引爆, 变为6颗角色的泪弹#被摧毁时爆出角色的泪弹", -- Tear Detonator
	[386] = "5%概率发射将石头/罐子/头骨/蘑鼓重置的泪弹", -- D12
	[396] = "每个传送门有1魂火", -- Ventricle Razor
	[406] = "随机伤害和射速", -- D8
	[419] = "20%概率发射传送敌人的泪弹#魂火每5秒闪匿一次", -- Teleport 2.0
	[421] = "{{Charm}}被摧毁时产生魅惑屁", -- Kidney Bean
	[422] = "30%概率发射{{Petrify}}石化泪弹#使上个房间被摧毁的所有魂火重生", -- Glowing Hour Glass
	[427] = "在房间中弹动, 被角色击中时爆炸#不造成接触伤害", -- Mine Crafter
	[434] = "生成魂火而不是苍蝇#最多5只苍蝇产生血量和伤害增强的1魂火", -- Jar of Flies
	[437] = "首次击中时产生七面骰效果", -- D7
	[441] = "{{Chargeable}} 蓄力硫磺火泪弹#在超级喷射期间会持续发射", -- Mega Blast
	[475] = "死亡后保持存在", -- Plan C
	[476] = "若没复制掉落物, 则生成第二个魂火", -- D1
	[477] = "生成所有吸收的主动道具的魂火#本身不生成魂火", -- Void
	[478] = "被摧毁时暂停所有敌人和弹幕3秒", -- Pause
	[479] = "被摧毁时概率生成1{{Trinket}}饰品", -- Smelter
	[480] = "转换的掉落物越多, 生成的魂火血量越高#至少转换1掉落物才会生成魂火", -- Compost
	[481] = "5%概率发射将敌人变成随机魂火的泪弹", -- Dataminer
	[482] = "生成1随机魂火", -- Clicker
	[483] = "生成被摧毁时掉落金即爆炸弹的8魂火", -- Mama Mega!
	[484] = "被摧毁时产生等等, 啥? 的效果", -- Wait What?
	[485] = "受损时, 所有被掰弯的硬币魂火被摧毁或复制", -- Crooked Penny
	[486] = "概率抵消角色受到的伤害, 然后被摧毁", -- Dull Razor
	[487] = "不可摧毁的永久魂火#追击敌人并向其发射#不阻挡弹幕, 不造成接触伤害", -- Potato Peeler
	[488] = "生成所模仿道具的魂火(若非主动道具则改为随机魂火)", -- Metronome
	[489] = "带有所模仿骰子的效果", -- D Infinity
	[490] = "生成1随机魂火#若被摧毁, 则清理房间后重生", -- Eden's Soul
	[504] = "快速低伤害泪弹, 自动瞄准", -- Brown Nugget
	[507] = "击杀时概率生成1魂火", -- Sharp Straw
	[510] = "{{Collectible229}}萌死戳的肺/{{Collectible268}}腐烂宝宝/{{Collectible87}}洛基的角/{{Collectible118}}硫磺火泪弹", -- Delirious
	[515] = "生成1随机魂火#若被摧毁, 则清理房间后重生", -- Mystery Gift
	[516] = "泪弹像洒水器一样的8向发射", -- Sprinkler
	[521] = "三重泪弹#购买东西会摧毁所有代金券魂火", -- Coupon
	[522] = "捕获的弹幕变为魂火", -- Telekinesis
	[523] = "魂火只在掉落物品时生成#被摧毁时生成1随机掉落物", -- Moving Box
	[527] = "清理房间后, 魂火会打开箱子/门", -- Mr. ME!
	[536] = "将所有魂火变为{{HalfHeart}}半红心", -- Sacrificial Altar
	[545] = "{{Friendly}} 被摧毁时生成1友好的骷髅仔", -- Book of the Dead
	[550] = "10%概率对敌人触发妈腿践踏的泪弹", -- Broken Shovel
	[552] = "10%概率对敌人触发妈腿践踏的泪弹 ", -- Mom's Shovel
	[556] = "短程{{Collectible118}}硫磺火泪弹", -- Sulfur
	[557] = "↑ {{Luck}} 每有1幸运饼干魂火, 幸运+0.2", -- Fortune Cookie
	[578] = "魂火会滴落黄色水迹", -- Free Lemonade
	[580] = "进入新房间时概率产生红门", -- Red Key
	[582] = "最多1个", -- Wavy Cap
	[584] = "多个重复品无额外效果", -- Book of Virtues
	[604] = "东西落地时生成1-3魂火(最多8个)", -- Mom's Bracelet
	[609] = "50%概率生成1无敌魂火#50%概率摧毁所有永恒六面骰魂火", -- Eternal D6
	[611] = "根据充能量提升血量和伤害", -- Larynx
	[622] = "所有魂火由3普通魂火取代", -- Genesis
	[631] = "使所有魂火分裂(伤害减半)#第三次分裂时魂火会被摧毁", -- Meat Cleaver
	[638] = "免疫弹幕#接触时消除非头目敌人", -- Eraser
	[639] = "生成蓝苍蝇而不是发射泪弹", -- Yuck Heart
	[640] = "概率发射蓝火泪弹", -- Urn of Souls
	[650] = "当甜蝇宝宝对角弹跳时, 所有糖梅溜溜笛魂火无敌并同样弹跳", -- Plum Flute
	[653] = "红幽灵能发射泪弹", -- Vade Retro
	[655] = "使用期间产生临时魂火#快速泪弹", -- Spin to Win
	[685] = "生成的魂火翻三倍", -- Jar of Wisps
	[687] = "生成1随机魂火", -- Friend Finder
	[705] = "击杀敌人时产生1单房间魂火", -- Dark Arts
	[709] = "角色落地时生成3魂火", -- Suplex
	[710] = "合成时生成1随机魂火", -- Bag of Crafting
	[712] = "道具魂火发射追踪泪弹", -- Lemegeton
	[719] = "20%概率击杀敌人时掉落1{{Coin}}硬币", -- Keeper's Box
	[720] = "生成1随机魂火", -- Everything Jar
	[722] = "{{Chained}} 禁锢2个敌人#若只有1个敌人, 将其禁锢10秒#再次使用使用孤魂铁索会解除最近的敌人", -- Anima Sola
	[723] = "生成1随机魂火, 将所有魂火重置为该类型", -- Spindown Dice
	[728] = "激活时所有魂火围绕格罗", -- Gello
}

---------- Abyss Locust description parts ----------
EID.descriptions[languageCode].AbyssTexts = {
 	-- values inside {} brackets will be replaced with text parts below
	-- The placeholder therefore can be used in all parts that make up the abyss locust descriptions
	InfoText = "{amount}只{size}{speed}蝗虫({dmg})", -- values inside {} brackets will be replaced with text parts below
	InfoTextPlural = nil, -- Can be used by translators to provide a pluralized version of the InfoText
	Chance = "({1}%概率)", -- {1} will be replaced with the chance
	SpeedSlow = "缓慢", -- Speed < 1
	SpeedFast = "较快", -- Speed > 1
	SpeedDash = "非常快", -- Speed >= 6
	SizeSmall = "小型", -- Size < 1
	SizeBig = "大型", -- Size > 1
	DamageMult = "{1}x角色伤害", -- {1} will be replaced with the calculated damage multiplier 
}

---------- Abyss Locust special effects ----------
--- Special locust effects that dont correspond to TearFlags.
--- Displays an icon in front of the description that shows an item with the same effect
EID.descriptions[languageCode].AbyssLocustEffects = {
[0] = "{{Bomb}} 造成伤害时爆炸",
[1] = "{{QuestionMark}} 随机蝗虫效果",
-- 2 = Multiple locusts act like one. Uninteresting info for the player in my opinion
[3] = "{{Collectible285}} 造成伤害时重置敌人",
[4] = "{{Collectible35}} 造成伤害时对所有敌人造成伤害",
[5] = "{{Collectible638}} 造成伤害时擦除敌人",
[6] = "{{Collectible114}} 攻击时携带一把旋转的菜刀",
[7] = "{{Collectible611}} 使用声带的音波, 对周围敌人造成伤害",
[8] = "{{Collectible399}} 生成1个虚空之喉光激光环",
[9] = "{{Collectible522}} 冲锋时具有排斥弹幕的光环",
[10] = "{{Collectible447}} 造成伤害时生成毒屁",
[11] = "{{Collectible447}} 造成伤害时生成屁",
[12] = "{{Collectible118}} 造成伤害时生成反重力硫磺火",
[13] = "{{Collectible317}} 造成伤害时生成绿色水迹",
[14] = "{{Collectible56}} 造成伤害时生成黄色水迹",
[15] = "{{Collectible214}} 造成伤害时生成红色水迹",
[16] = "{{Collectible178}} 造成伤害时生成蓝色水迹",
[17] = "{{Collectible420}} 随机生成1个五芒星",
[18] = "{{Collectible144}} 每吞噬1个掉落物, 伤害+0.25#至多吞噬25个掉落物",
}


-- list of Tear flag descriptions used for Abyss locust effect description
EID.descriptions[languageCode].TearFlagNames = {
	[0] = "灵体",                 -- Ouija board type tear (goes thru obstacles)
    [1] = "穿刺",                 -- Cupid's arrow type tear (goes thru enemy)
    [2] = "追踪",                   -- Spoon bender type tear (homes to enemy)
    [3] = "减速",                  -- Spider bite type tear (slows on contact)
    [4] = "毒性",                   -- Common cold type tear (poisons on contact)
    [5] = "石化",                  -- Mom's contact type tear (freezes on contact)
    [6] = "分裂",                    -- Parasite type tear (splits on collision)
    [7] = "伤害随距离提升",            -- Lump of coal type tear (grows by range)
    [8] = "回旋",                -- My reflection type tear (returns back)
    [9] = "持续",               -- Polyphemus type tear (Damages the entity and if the damage is more then enemy hp it continues with less damage
    [10] = "扭扭虫",         -- Wiggle worm type tear (wiggles)
    [11] = "击中时生成蓝苍蝇",        -- Mulligan type tear (creates fly on hit)
    [12] = "爆炸",               -- IPECAC type tear (explodes on hit)
    [13] = "魅惑",                -- Mom's Eyeshadow tear
    [14] = "混乱",               -- Iron Bar tear
    [15] = "敌人掉落心",     -- These tears cause enemy to drop hearts if killed (33% chance)
    [16] = "在角色周围环绕",     -- Used for Little Planet (orbit arounds the player)
    [17] = "反重力",     -- Anti gravity type tear (floats in place for some time before finally moving) (unset after first update)
    [18] = "四向分裂",     -- Splits into 4 smaller tears if it hits the ground
    [19] = "在敌人之间反弹",       -- Bounce off of enemies, walls, rocks (Higher priority than PERSISTENT & PIERCING)
    [20] = "恐惧",                    -- Mom's Perfume type tear of fear (fear on contact)
    [21] = "逐渐缩小",                  -- Proptosis tears start large and shrink
    [22] = "燃烧",                    -- Fire Mind tears cause Burn effect on enemies
    [23] = "磁化", -- Attracts enemies and pickups
    [24] = "击退",               -- Tear impact pushes enemies back further
    [25] = "波动虫",               -- Makes the tear pulse
    [26] = "环形虫",         -- Makes the tear path spiral
    [27] = "扁形虫",              -- Makes the tear oval in the direction of travel
    [28] = "悲伤炸弹",                -- Used by Bombs (Sad Bomb)
    [29] = "屁股炸弹",               -- Used by Bombs (Butt Bomb)
    [30] = "钩形虫",         -- Used for Hook Worm
    [31] = "造成伤害的光环",     -- Used for GodHead (they will have a glow around them)
    [32] = "减速", -- Used for Gish player tears (to color enemy black on slowing)
    [33] = "击中时产生绿色水迹", -- Mysterious Liquid tears spawn damaging green creep when hit
    [34] = "护盾",                -- Lost Contact tears, block enemy projectiles
    [35] = "闪光炸弹",            -- Used by Bombs (Glitter Bomb)
    [36] = "分裂炸弹",            -- Used for Scatter bombs
    [37] = "粘性",                  -- Used for Sticky bombs and Explosivo tears
    [38] = "穿过屏幕",     -- Tears loop around the screen
    [39] = "击中时生成圣光", -- Create damaging light beam on hit
    [40] = "击中时掉落硬币",        -- Used by Bumbo, spawns a coin when tear hits
    [41] = "击杀敌人时掉落黑心",    -- Enemy drops a black hp when dies
    [42] = "牵引光束",            -- Tear with this flag will follow parent player's beam
    [43] = "缩小敌人",          -- God's flesh flag to minimize enemies
    [44] = "击中时生成硬币",      -- Greed coin tears that has a chance to generate a coin when hit
    [45] = "十字爆炸",              -- Bomber Boy
    [46] = "衔尾虫",     -- Ouroboros Worm, big radius oscilating tears
    [47] = "击中时永久混乱",   -- Glaucoma tears, permanently confuses enemies
    [48] = "鼻窦炎",                  -- Booger tears, stick and do damage over time
    [49] = "击中时生成蓝苍蝇/蓝蜘蛛",               -- Egg tears, leave creep and spawns spiders or flies
    [50] = "击中时破坏石头等障碍物",            -- Sulfuric Acid tears, can break grid entities
    [51] = "击杀敌人时生成1-2个骨片",                    -- Bone tears, splits in 2
    [52] = "穿透敌人, 随后获得双倍伤害与追踪", -- Belial tears, piecing tears gets double damage + homing
    [53] = "将接触到的敌人变为金块",           -- Midas touch tears
    [54] = "击中时爆出10颗泪弹",                -- Needle tears
    [55] = "击中时产生电弧",           -- Jacobs ladder tears
    [56] = "击中时召唤巨角恶魔的手", -- Little Horn tears
    [57] = "以电弧连接",   -- Technology Zero
    [58] = "互相弹开",        -- Pop!
    [59] = "互相吸收",               -- Hungry Tears
    [60] = "光束",               -- Trisagion, generates a laser on top of the tear
    [61] = "在地面弹跳",          -- Flat Stone
    [62] = "爆裂",             -- Haemolacria
    [63] = "水迹",             -- Bob's Bladder
    [64] = "击中时有拳击效果",     -- Knockout Drops
    [65] = "击杀敌人时使其冻结",   -- Uranus
    [66] = "吸引敌人和掉落物", -- Lodestone
    [67] = "击中时有诱饵效果",       -- Rotten Tomato
    [68] = "玄秘魔眼",       -- Eye of the Occult
    [69] = "环形轨道运动",   -- Orbiting tears with a more narrow and stable orbit (used by Saturnus and Immaculate Heart)
    [70] = "碎岩",             -- Rock tears, chance to break rocks, deal extra damage to rock type enemies
    [71] = "脑形虫",      -- Brain Worm, tears turn and go horizontally when moving past an enemy
    [72] = "鲜血炸弹 ",              -- Blood Bombs, leave blood creep on the ground
    [73] = "将敌人变为大便",    -- E. Coli tears, turn enemies into poop
    [74] = "击杀敌人时掉落硬币",      -- Killed enemies have a chance to drop a random coin (Reverse Hanged Man)
    [75] = "硫磺火炸弹",          -- Brimstone Bombs, explosion creates a brimstone cross
    [76] = "击中时产生黑洞",       -- Rift tears, creates a black hole on impact
    [77] = "粘在敌人身上, 敌人死亡时增殖",  -- Spore tears, stick to enemies and multiply on enemy death
    [78] = "幽灵炸弹",              -- Ghost bombs
    [79] = "击杀敌人时掉落卡牌",      -- Killed enemies will drop a random tarot card
    [80] = "击杀敌人时掉落符文",      -- Killed enemies will drop a random rune
    [81] = "击中时传送敌人",   -- Hit enemies will teleport to a different part of the room
    [82] = "随时间减速",    -- Decelerate over time
    [83] = "随时间加速",    -- Accelerate over time
    [104] = "弹跳(仅墙壁间)",    -- Similar to TEAR_BOUNCE but only bounces off walls, not enemies
	[106] = "背后攻击造成额外伤害+流血",   -- Deals extra damage from behind and inflicts bleeding
}

-- Special Locust effects when Item was eaten by Abyss. Entries here will override the auto-generated descriptions
-- Kept in for backwards compatibility
EID.descriptions[languageCode].abyssSynergies = {}

-- Effect of Car battery on Active Items
local repCarBattery = {
	[34] = {2, 3}, -- The Book of Belial
	[59] = {2, 3}, -- The Book of Belial (Birthright)
	[83] = {"半", "1"}, -- The Nail
	[263] = "触发两次", -- Clear Rune
	[283] = {1, 2}, -- D100
	[285] = "降级两次", -- D10
	[288] = {"4-8", "8-16"}, -- Box of Spiders
	[293] = {200, 400}, -- Head of Krampus
	[296] = {1, 2, 1, 2}, -- Converter
	[323] = "泪弹造成的伤害翻倍", -- Isaac's Tears
	[386] = "提升生成稀有障碍物的概率", -- D12
	[485] = "25%概率翻四倍, 75%概率移除", -- Crooked Penny
	[489] = "使用选中骰子的效果两次", -- D Infinity
	[522] = {3, 6}, -- Telekinesis
	[557] = {"其一", "其中两个"}, -- Fortune Cookie
	[582] = "触发两次", -- Wavy Cap
	[584] = "生成2魂火", -- Book of Virtues
	[605] = {1, 2}, -- The Scooper
	[609] = {25, 44}, -- Eternal D6
	[611] = "额外触发一次1充能怒吼", -- Larynx
	[625] = {30, 60}, -- Mega Mush
	[631] = {25, 50}, -- Meat Cleaver
	[635] = "立即交换两次#可用于传送到敌人处造成伤害, 但无法收集够不到的道具", -- Stitches
	[639] = {1, 2}, -- Yuck Heart
	[642] = "触发两次", -- Magic Skin
	[650] = {1, 2}, -- Plum Flute
	[685] = "生成双倍魂火, 但使用计数只+1", -- Jar of Wisps
	[687] = {1, 2}, -- Friend Finder
	[704] = "持续10秒, 但击杀敌人仍然只能延长至5秒", -- Berserk!
	[705] = {1, 2}, -- Dark Arts
	[712] = {1, 2}, -- Lemegeton
	[713] = {"半心", "1心", 1, 2}, -- Sumptorium
	[719] = {1, 2}, -- Keeper's Box
	[720] = "再额外生成1个大便", -- Everything Jar
	[722] = "禁锢2名敌人#若只有1名敌人, 将其禁锢10秒#再次使用会释放最近的被禁锢的敌人", -- Anima Sola
	[723] = {1, 2}, -- Spindown Dice
}
EID:updateDescriptionsViaTable(repCarBattery, EID.descriptions[languageCode].carBattery)

-- Effect of BFFS!/Hive Mind on Familiars
local repBFFSSynergies = {
	["5.100.67"] = {6, 12}, -- Sister Maggy
	["5.100.98"] = {"7-8", "6"}, -- The Relic
	["5.100.107"] = {23.5, 47}, -- The Pinking Shears
	["5.100.172"] = {112.5, 225}, -- Sacrificial Dagger
	["5.100.178"] = {7, 14, "在击中处生成1蓝火"}, -- Holy Water
	["5.100.206"] = {56, 112}, -- Guillotine
	["5.100.264"] = {6.5, 13}, -- Smart Fly
	["5.100.272"] = {100, 125}, -- BBF
	["5.100.273"] = {100, 125}, -- Bob's Brain
	["5.100.274"] = {150, 300}, -- Best Bud
	["5.100.275"] = {24, 48}, -- Lil Brimstone
	["5.100.276"] = "向随机方向额外发射泪弹, 留下更大的水迹", -- Isaac's Heart
	["5.100.319"] = {0.75, 1.5}, -- Cain's Other Eye
	["5.100.320"] = {15, 30}, -- ???'s Only Friend
	["5.100.360"] = {0.75, 1.5, 1, 2}, -- Incubus (+ Lilith exception)
	["5.100.365"] = {30, 60}, -- Lost Fly
	["5.100.384"] = {"5-20", "10-40"}, -- Lil Gurdy
	["5.100.389"] = {"7-8", "6"}, -- Rune Bag
	["5.100.467"] = {0.1, 0.2}, -- Finger!
	["5.100.468"] = {75, 150}, -- Shade
	["5.100.491"] = {"7", "6"}, -- Acid Baby
	["5.100.500"] = {"7-8", "6"}, -- Sack of Sacks
	["5.100.504"] = {3.5, 7}, -- Brown Nugget
	["5.100.508"] = {1.5, 3}, -- Mom's Razor
	["5.100.509"] = {3.5, 7, 20, 40}, -- Bloodshot Eye

	["5.100.565"] = "友好时造成的伤害翻倍", -- Blood Puppy
	["5.100.569"] = "若触发, 则获得额外伤害和移速", -- Blood Oath
	["5.100.575"] = {1.5, 3}, -- The Intruder
	["5.100.581"] = {15, 30}, -- Psy Fly
	["5.100.584"] = "魂火射速和接触伤害翻倍", -- Book of Virtues
	["5.100.605"] = {36, 72}, -- The Scooper
	["5.100.607"] = {3.5, 7, 5.25, 10.5}, -- Boiled Baby
	["5.100.608"] = {3.5, 7}, -- Freezer Baby
	["5.100.610"] = {45, 90, "岩石波", "4道{{CR}}岩石波", 6.5, 13}, -- Bird Cage
	["5.100.612"] = "给予迷失游魂神圣屏障的效果", -- Lost Soul
	["5.100.626"] = {25, 50}, -- Knife Piece 1
	["5.100.627"] = {25, 50}, -- Knife Piece 2
	["5.100.629"] = {3, 6}, -- Bot Fly
	["5.100.635"] = "使用时, 在角色位置发射8颗泪弹", -- Stitches
	["5.100.645"] = {3.5, 7}, -- Tinytoma
	["5.100.649"] = {3, 6, 6, 12}, -- Fruity Plum
	["5.100.650"] = "接触伤害翻倍", -- Plum Flute
	["5.100.652"] = {17.5, 35}, -- Cube Baby
	["5.100.655"] = {10.5, 21, "幸运转盘使用时, 所有跟班都没有好朋友一辈子的伤害加成"}, -- Spin to Win
	["5.100.679"] = {52.5, 105}, -- Lil Abaddon
	["5.100.681"] = "伤害翻倍", -- Lil Portal
	["5.100.682"] = {8, 16}, -- Worm Friend
	["5.100.685"] = "魂火射速和接触伤害翻倍", -- Jar of Wisps
	["5.100.698"] = {0.375, 0.75}, -- Twisted Pair
	["5.100.702"] = "魂火射速和接触伤害翻倍", -- Vengeful Spirit
	["5.100.706"] = "蝗虫伤害提升至1.25x", -- Abyss
	["5.100.712"] = "环绕物接触伤害翻倍", -- Lemegeton
	["5.100.713"] = "血团伤害翻倍", -- Sumptorium
	["5.100.728"] = {0.75, 1.5, 1, 2}, -- Gello (+ Lilith exception)

	["5.300.96"] = "魂火射速和接触伤害翻倍", -- Soul of Bethany
	["5.350.142"] = "魂火射速和接触伤害翻倍", -- Beth's Faith
	["5.350.182"] = "魂火射速和接触伤害翻倍", -- Beth's Essence
	["5.350.176"] = "血团伤害翻倍", -- Lil Clot
	["5.350.186"] = "蝗虫伤害提升至1.25x", -- Apollyon's Best Friend
	["Tainted Lilith"] = "格罗的泪弹伤害翻倍", -- Gello (for BFFS pedestal)
}
EID:updateDescriptionsViaTable(repBFFSSynergies, EID.descriptions[languageCode].BFFSSynergies)

---------- Trinkets ----------

local repTrinkets={
	[10] = {"10", "扭扭虫", "↑ {{Tears}} 射速+0.4#灵体泪弹#角色的泪弹波形前进"}, -- Wiggle Worm
	[11] = {"11", "环形虫", "↑ {{Tears}} 射速+0.47#灵体泪弹#角色的泪弹高速螺旋前进"}, -- Ring Worm
	[15] = {"15", "幸运石", "{{Coin}} 摧毁石头有33%概率生成1硬币"},-- Lucky Rock
	[16] = {"16", "妈妈的脚趾甲", "每20秒妈腿会践踏房间中的随机位置"}, -- Mom's Toenail
	[24] = {"24", "屁股硬币", "{{Coin}} 大便产生硬币的概率+20%#{{Poison}} 角色拾起硬币时放屁, 使敌人中毒并击退敌人和弹幕"}, -- Butt Penny
	[26] = {"26", "钩形虫", "↑ {{Tears}} 射速+0.4#↑ {{Range}} 射程+1.5#灵体泪弹#泪弹直角前进"}, -- Hook Worm
	[32] = {"32", "裸盖蘑菇", "每个房间25%概率出现随机蘑菇效果"}, -- Liberty Cap
	[33] = {"33", "脐带", "{{HalfHeart}} 不多于半红心时, 获得{{Collectible100}}小史蒂文#{{Collectible318}} 受伤时高概率在当前房间中生成双子座的跟班"}, -- Umbilical Cord
	[39] = {"39", "癌症", "↑ {{Tears}} 射速+1"}, -- Cancer
	[48] = {"48", "遗失的书页", "受伤时有5%概率对房间中所有敌人造成80点伤害#黑心和类似{{Collectible35}}死灵之书的效果造成双倍伤害"}, -- A Missing Page
	[49] = {"49", "染血硬币", "{{HalfHeart}} 拾起硬币时, 25%概率生成1半红心#镍币和铸币生成红心概率更高"}, -- Bloody Penny
	[50] = {"50", "焦灼硬币", "{{Bomb}} 拾起硬币时, 25%概率生成1炸弹#镍币和铸币生成炸弹概率更高"}, -- Burnt Penny
	[51] = {"51", "扁平硬币", "{{Key}} 拾起硬币时, 25%概率生成1钥匙#镍币和铸币生成钥匙概率更高"}, -- Flat Penny
	[65] = {"65", "长条虫", "↑ {{Range}} 射程+3"}, -- Tape Worm
	[66] = {"66", "懒散虫", "↓ {{Shotspeed}} 弹速-0.5"}, -- Lazy Worm
	[67] = {"67", "碎裂六面骰", "受伤时, 50%概率触发以下骰子效果之一:#{{Collectible105}} 六面骰#{{Collectible406}} 八面骰#{{Collectible285}} 十面骰#{{Collectible386}} 十二面骰#{{Collectible166}} 二十面骰"}, -- Cracked Dice
	[69] = {"69", "褪色的全家福", "随机使角色伪装#{{Confusion}} 使敌人混乱#可以用于打开\"深牢II\"的\"奇怪的门\""}, -- Faded Polaroid
	[80] = {"80", "黑色羽毛", "↑ {{Damage}} 每持有1个\"邪恶上升\"道具, 伤害+0.5"}, -- Black Feather
	[92] = {"92", "碎裂的王冠", "↑ 高于{{Speed}}移速1, {{Tears}}射速2.73, {{Damage}}伤害3.5, {{Range}}射程6.5, {{Shotspeed}}弹速1的部分修正x1.2"}, -- Cracked Crown
	[96] = {"96", "衔尾虫", "↑ {{Tears}} 射速+0.4#↑ {{Range}} 射程+1.5#灵体泪弹#概率为追踪泪弹#{{Luck}} 幸运9: 100%概率#角色的泪弹螺旋快速前进"}, -- Ouroboros Worm
	[98] = {"98", "鼻涕泡", "5%概率发射追踪粘性泪弹#{{Damage}} 每秒造成1x角色伤害#能粘住10秒"}, -- Nose Goblin
	[101] = {"101", "暗灯泡", "持有完全未充能的主动道具时:#↑ {{Speed}} 移速+0.5#↑ {{Tears}} 射速+0.5#↑ {{Damage}} 伤害+1.5#↑ {{Range}} 射程+1.5#↑ {{Shotspeed}} 弹速+0.3#↑ {{Luck}} 幸运+2"}, -- Dim Bulb
	[107] = {"107", "乌鸦的心", "受伤时, 首先消耗红心, 然后消耗魂心/黑心#{{Warning}} 红心伤害会降低恶魔房/天使房概率"}, -- Crow Heart
	[110] = {"110", "银币", "{{Shop}} 商店会出现在子宫和尸宫中"},
	[111] = {"111", "染血王冠", "{{TreasureRoom}} 宝箱房会出现在子宫和尸宫中"}, -- Bloody Crown
	[119] = {"119", "干细胞", "{{HealingRed}} 进入新层时, 治疗一半空心之容器/空骨心#{{HealingRed}} 至少治疗半红心"}, -- Stem Cell
	[128] = {"128", "指骨", "{{EmptyBoneHeart}} 受伤时, 4%概率获得骨心"}, -- Finger Bone
	[129] = {"129", "崩掉牙", "{{Damage}} 10%概率发射牙齿, 造成3.2x角色伤害#{{Luck}} 幸运9: 100%概率"}, --  Jawbreaker
	[130] = {"130", "嚼烂的笔", "{{Slow}} 10%概率发射减速泪弹#{{Luck}} 幸运18: 100%概率"}, --  Chewed Pen
	[131] = {"131", "神圣硬币", "{{HalfSoulHeart}} 拾起硬币时, 17%概率生成半魂心#镍币和铸币生成半魂心概率更高"}, --  Blessed Penny
	[132] = {"132", "损坏的注射器", "25%概率在当前房间中获得随机药剂效果"}, --  Broken Syringe
	[133] = {"133", "短引线", "角色放置的炸弹爆炸更快"}, --  Short Fuse
	[134] = {"134", "巨豆", "增加屁的大小"}, --  Gigante Bean
	[135] = {"135", "打火机", "{{Burning}} 进入房间时, 20%概率对敌人施加燃烧效果"}, --  A Lighter
	[136] = {"136", "损坏的挂锁", "门, 钥匙方块和金箱子可以用爆炸打开#爆炸也可打开\"深牢II\"的\"奇怪的门\""}, --  Broken Padlock
	[137] = {"137", "勿忘草", "进入新层时, 上一层未收集的最多4个掉落物在初始房间生成"}, --  Myosotis
	[138] = {"138", "'M", "使用主动道具后, 将该主动道具重置"}, --  'M
	[139] = {"139", "泪滴护符", "{{Luck}} 对基于幸运的泪弹效果, 幸运+4"}, --  Teardrop Charm
	[140] = {"140", "所多玛之果", "拾起红心时, 50%概率将其变成蓝蜘蛛#满血时改为100%"}, --  Apple of Sodom
	[141] = {"141", "失落摇篮曲", "跟班的射速翻倍"}, --  Forgotten Lullaby
	[142] = {"142", "伯大尼的信仰", "{{Collectible584}} 进入新层时, 生成4美德之书魂火"}, --  Beth's Faith
	[143] = {"143", "老旧电容", "{{Battery}} 阻止主动道具通过清理房间充能#{{Battery}} 清理房间后, 20%概率生成1电池#{{Luck}} 幸运5: 33%"}, --  Old Capacitor
	[144] = {"144", "脑形虫", "泪弹若会打不中敌人, 则90度转向敌人"}, --  Brain Worm
	[145] = {"145", "满分考卷", "↑ {{Luck}} 幸运+10#受伤时摧毁此饰品"}, -- Perfection
	[146] = {"146", "恶魔王冠", "{{RedTreasureRoom}} 宝箱房道具由恶魔交易取代"}, --  Devil's Crown
	[147] = {"147", "充能硬币", "{{Battery}} 拾起硬币时, 17%概率对主动道具充能1格#镍币和铸币的充能概率更高"}, --  Charged Penny
	[148] = {"148", "友谊项链", "使所有跟班环绕角色"}, --  Friendship Necklace
	[149] = {"149", "紧急按钮", "即将受伤时, 若主动道具已充能, 则使用主动道具"}, --  Panic Button
	[150] = {"150", "蓝钥匙", "锁住的门可以免费打开, 但角色需要在进入房间前清理一个死寂层的房间"}, --  Blue Key
	[151] = {"151", "扁锉", "尖刺全部缩回, 不造成伤害#也影响{{CursedRoom}}诅咒房的门, 刺箱子和任何尖刺障碍物"}, --  Flat File
	[152] = {"152", "望远镜片", "{{PlanetariumChance}} 星象房基概率+9%#{{PlanetariumChance}} 第一次进入星象房前, 概率额外+15%#星象房会出现在子宫和尸宫中"}, --  Telescope Lens
	[153] = {"153", "妈妈的发髻", "每个房间有25%概率获得随机妈妈道具的效果"}, --  Mom's Lock
	[154] = {"154", "骰子袋", "每个新房间有50%概率获得1个一次性的随机骰子#骰子在离开房间后消失#骰子不占用胶囊/卡牌位"}, --  Dice Bag
	[155] = {"155", "神圣王冠", "在教堂中生成{{TreasureRoom}}宝箱房和{{Shop}}商店"}, --  Holy Crown
	[156] = {"156", "母亲的吻", "持有时+1心之容器"}, --  Mother's Kiss
	[157] = {"157", "扑克牌残片", "每发射15次, 发射1颗{{Collectible149}}吐根酊+{{Collectible5}}我的镜像效果的泪弹, 其射程极高"}, --  Torn Card
	[158] = {"158", "破损的口袋", "受伤时, 角色掉落持有的2硬币/钥匙/炸弹#该掉落物可能会变为变体, 比如金钥匙, 镍币, 铸币等"}, --  Torn Pocket
	[159] = {"159", "镀金钥匙", "{{Key}} 首次拾起时+1钥匙#{{GoldenChest}} 所有新生成的箱子(除了旧箱子和巨型箱子)由金箱子取代#{{GoldenChest}} 金箱子可能含有额外的卡牌/胶囊/饰品"}, --  Gilded Key
	[160] = {"160", "幸运袋", "{{GrabBag}} 进入新层时生成1福袋"}, --  Lucky Sack
	[161] = {"161", "邪恶王冠", "在阴间中生成{{TreasureRoom}}宝箱房和{{Shop}}商店"}, --  Wicked Crown
	[162] = {"162", "阿撒泻勒的残角", "{{Player7}} 清理房间后有50%概率变为阿撒泻勒#{{Timer}} 效果持续到清理或离开另一个房间"}, --  Azazel's Stump
	[163] = {"163", "粪蛋", "所有粪滴敌人友好#清理房间后生成1个随机粪滴"}, --  Dingle Berry
	[164] = {"164", "火药圈", "{{Bomb}} 放置炸弹时生成1额外炸弹"}, --  Ring Cap
	[165] = {"165", "滚啊！", "在子宫及以后中, 所有硬币和钥匙由炸弹/心/胶囊/卡牌/饰品/电池/红苍蝇取代"}, --  Nuh Uh!
	[166] = {"166", "塑型黏土", "每个房间有50%概率获得随机被动道具的效果"}, --  Modeling Clay
	[167] = {"167", "抛光骨头", "{{Friendly}} 清理房间后, 25%概率生成友好的骷髅仔"}, --  Polished Bone
	[168] = {"168", "空壳心", "{{EmptyBoneHeart}} 进入新层时+1骨心"}, --  Hollow Heart
	[169] = {"169", "儿童涂鸦", "{{Guppy}} 持有时算作1个嗝屁猫套装道具"}, --  Kid's Drawing
	[170] = {"170", "水晶钥匙", "{{Collectible580}} 清理房间后, 33%概率产生红钥匙房间#红色房间中触发概率降低"}, --  Crystal Key
	[171] = {"171", "店主的协议", "{{DevilRoom}} 50%概率使恶魔交易花费硬币而不是心"}, --  Keeper's Bargain
	[172] = {"172", "诅咒硬币", "{{Coin}} 拾起硬币时, 将角色传送至随机房间#可以传送至隐藏房"}, --  Cursed Penny
	[173] = {"173", "你的灵魂", "{{DevilRoom}} 允许免费进行一次恶魔交易#{{Warning}} 免费交易也会影响天使房概率"}, --  Your Soul
	[174] = {"174", "数字冰箱贴", "{{DevilChance}} 恶魔房概率+10%#防止恶魔房中出现坎卜斯#恶魔房变为特殊房间布局, 有更多的交易, 黑心和敌人"}, --  Number Magnet
	[175] = {"175", "奇怪的钥匙", "无论时间, 打开死寂的门#使用{{Collectible297}}潘多拉的盒子时, 从随机道具池生成6个道具"}, --  Strange Key
	[176] = {"176", "小血团", "生成1个血块跟班, 模仿角色的行动#复制角色的属性和泪弹效果, 造成0.35x角色伤害#每个房间重生"}, --  Lil Clot
	[177] = {"177", "纹身贴", "{{Chest}} 清理{{ChallengeRoom}}挑战房后, 生成1箱子#清理{{BossRushRoom}}头目挑战房, 生成1道具"}, --  Temporary Tattoo
	[178] = {"178", "被吞下的M80鞭炮", "受伤时角色有50%概率爆炸#不会摧毁交互中的献血机或忏悔室, 但会生成摧毁时的掉落物"}, --  Swallowed M80
	[179] = {"179", "赛车遥控器", "跟班模仿角色的移动#按住掉落键({{ButtonRT}})使跟班留在原地"}, --  RC Remote
	[180] = {"180", "复得游魂", "精确跟随角色移动, 发射灵体泪弹#复制角色的属性和泪弹效果, 造成0.5x角色伤害#使用角色使用的大多数主动道具#复得游魂受伤即死#每层重生"}, --  Found Soul
	[181] = {"181", "扩展电路板", "使用主动道具时, 额外触发随机1-2充能的主动道具"}, --  Expansion Pack
	[182] = {"182", "伯大尼的精华", "进入{{AngelRoom}}天使房时, 生成5魂火#向乞丐捐钱时, 25%概率生成1魂火"}, --  Beth's Essence
	[183] = {"183", "双胞胎", "每个房间有50%概率复制1个跟班#若角色没有跟班, 则获得{{Collectible8}}波比兄弟或{{Collectible67}}玛姬姐妹"}, --  The Twins
	[184] = {"184", "领养协议书", "{{Shop}} 商店的道具由跟班取代, 10硬币出售"}, --  Adoption Papers
	[185] = {"185", "蟋蟀腿", "杀死敌人时, 17%概率生成1只随机蝗虫"}, --  Cricket Leg
	[186] = {"186", "亚玻伦的挚友", "{{Collectible706}} 生成1只无底坑蝗虫"}, --  Apollyon's Best Friend
	[187] = {"187", "碎掉的眼镜", "{{TreasureRoom}} 50%概率在宝箱房添加1个额外的问号道具#{{TreasureRoom}} 50%概率揭示替代章节的问号道具"}, --  Broken Glasses
	[188] = {"188", "冰块", "{{Petrify}} 进入房间时, 20%概率石化1个敌人#{{Freezing}} 击杀石化的敌人可将其冻结"}, --  Ice Cube
	[189] = {"189", "巴风特之印", "击杀敌人时, 使角色无敌1秒#期间击杀敌人额外增加1秒无敌"}, --  Sigil of Baphomet
}
EID:updateDescriptionsViaTable(repTrinkets, EID.descriptions[languageCode].trinkets)

EID.descriptions[languageCode].goldenTrinket = "效果翻倍!"
EID.descriptions[languageCode].tripledTrinket = "效果翻三倍!"
EID.descriptions[languageCode].quadrupledTrinket = "效果翻四倍!"

-- Most trinkets that can be doubled or tripled just have the numbers in their description multiplied
-- A few trinkets have odd edge cases where their effect completely changes, or is different depending on if it's Mom's Box or Golden
EID.descriptions[languageCode].goldenTrinketEffects = {
	-- Broken Remote (replace with Teleport 2.0 info)
	[4] = { "{{Collectible419}} 使用主动道具时, 将角色传送至{{ColorGold}}未探索的随机房间{{CR}}#顺序: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"}, -- Teleport 2.0
	-- Broken Magnet (find+replace): find Phrase #1 in the localized description, change it to Phrase #2 for doubled
	[6] = { "硬币", "掉落物" },
	-- Rosary Bead append
	[7] = { "{{Collectible72}} 念珠添加至所有道具池" },
	-- Golden Store Credit: full replace
	[13] = { "{{Shop}} {{ColorGold}}允许角色免费拿商店道具{{CR}}#每次拿商品后有概率变为普通的{{Trinket13}}商店积分" },
	-- Lucky Rock append (Gold / Mom's Box / Both)
	[15] = { "石头可能掉落2硬币", "石头可能掉落2硬币", "石头可能掉落3硬币" },
	-- Golden Mysterious Candy makes Golden Poop
	[25] = { "大便", "金大便" },
	-- Isaac's Fork (find+replace): find Phrase #1 in the localized description, change it to Phrase #2 or 3 for doubled/tripled
	[46] = { "半红心", "1红心", "1.5红心" },
	-- Tick (replace): A full replacement for Golden / Mom's Box / Both, as the Golden version can be removed and only one effect is tripled
	[53] = {
		"{{HealingRed}} 进入{{BossRoom}}头目房时治疗{{ColorGold}}2{{CR}}红心#头目血量-{{ColorGold}}30{{CR}}%#{{ColorGold}}可以直接移除!",
		"{{HealingRed}} 进入{{BossRoom}}头目房时治疗{{ColorGold}}2{{CR}}红心#头目血量-{{ColorGold}}30{{CR}}%#!!! 拾起后无法被其他饰品替换#只能被{{Trinket41}}火柴棒移除或吞下",
		"{{HealingRed}} 进入{{BossRoom}}头目房时治疗{{ColorGold}}3{{CR}}红心#头目血量-{{ColorGold}}30{{CR}}%#{{ColorGold}}可以直接移除!",
	},
	-- Rainbow Worm (append): With Mom's Box, it gives 2 copies of the temp worm, and doubles 1 of those copies, for triple effect
	[64] = { "蠕虫属性效果翻倍", "蠕虫属性效果翻三倍", "蠕虫属性效果翻四倍", },
	-- Error (append): Same behavior as Rainbow Worm
	[75] = { "若可能, 饰品效果翻倍", "若可能, 饰品效果翻三倍", "若可能, 饰品效果翻四倍", },
	-- NO!
	[88] = { "阻止品质{{Quality0}}道具生成" },
	-- Gilded Key (Golden version only): it doesn't give a key. bug that will get fixed (maybe it'll give a Golden Key?)
	[159] = { "{{GoldenChest}} 所有新生成的箱子(除了旧箱子和巨型箱子)由金箱子取代#{{GoldenChest}} 金箱子可能含有额外的卡牌/胶囊/饰品" },
	-- The Twins
	[183] = { "可复制/获得2个跟班", "可复制/获得2个跟班", "可复制/获得3个跟班" },
}

--[[
Localizations may choose to overwrite specific data from EID.GoldenTrinketData in this table. For advanced users only.
Example: If French uses "Double" instead of "2x" for Purple Heart, they can do:
EID.descriptions[languageCode].goldenTrinketData = {
	[5] = {findReplace = true, mult = 2},
}
and then place
	[5] = { "Double", "Quadruple" },
in their goldenTrinketEffects
]]
EID.descriptions[languageCode].goldenTrinketData = { }

---------- Cards ----------

local repCards={
	[2] = {"2", "I-魔术师", "{{Timer}} 当前房间中获得:#追踪泪弹#↑ {{Range}} 射程+3"}, -- I - The Magician
	[12] = {"12", "XI-力量", "{{Timer}} 当前房间中获得:#↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.3#↑ {{Damage}} 伤害+0.3#↑ {{Damage}} 伤害修正x1.5#↑ {{Range}} 射程+2.5"}, -- XI - Strength
	[16] = {"16", "XV-恶魔", "{{Timer}} 当前房间中获得:#↑ {{Damage}} 伤害+2"}, -- XV - The Devil
	[18] = {"18", "XVII-星星", "{{TreasureRoom}} 将角色传送至宝箱房#{{Planetarium}} 若当前层有星象房, 则改为传送至星象房"}, -- XVII - The Star
	[20] = {"20", "XIX-太阳", "{{HealingRed}} 回满血#对所有敌人造成100点伤害#{{Timer}} 揭示本层全图并显示房间类型, {{SuperSecretRoom}}超级隐藏房/{{UltraSecretRoom}}究极隐藏房除外#{{CurseDarkness}} 移除黑暗诅咒"}, -- XIX - The Sun
	[21] = {"21", "XX-审判", "{{Beggar}} 生成1个乞丐#{{DemonBeggar}} 33%概率为恶魔乞丐#5%概率为钥匙大师/炸弹乞丐/腐烂乞丐"}, -- XX - Judgement
	[27] = {"27", "梅花A", "{{Bomb}} 将所有掉落物, 箱子和非头目敌人变成炸弹"}, -- Ace of Clubs
	[28] = {"28", "方片A", "{{Coin}} 将所有掉落物, 箱子和非头目敌人变成硬币"}, -- Ace of Diamonds
	[29] = {"29", "黑桃A", "{{Key}} 将所有掉落物, 箱子和非头目敌人变成钥匙"}, -- Ace of Spades
	[30] = {"30", "红桃A", "{{Heart}} 将所有掉落物, 箱子和非头目敌人变成随机心"}, -- Ace of Hearts
	[34] = {"34", "马骑符文", "生成1个前往下一层的活板门#{{LadderRoom}} 在有装饰(草/碎石/纸/宝石等)的地板上使用时, 改为生成暗门"}, -- Ehwaz
	[39] = {"39", "保护符文", "{{Timer}} 角色无敌20秒"}, -- Algiz
	[42] = {"42", "混沌卡", "使用时, 向角色移动方向投出#立即击杀接触到的任何敌人(精神错乱和祸兽除外)"}, -- Chaos Card
	[51] = {"51", "神圣卡", "{{HolyMantle}} 一次性神圣屏障护盾(阻挡1次伤害)"}, -- Holy Card
	[52] = {"52", "变巨术", "{{Timer}} 当前房间中获得:#↑ {{Damage}} 伤害+7#↑ {{Range}} 射程+3#体型变大#角色可粉碎接触的石头"}, -- Huge Growth
	[55] = {"55", "符文碎片", "随机符文效果#触发的符文效果较弱"}, -- Rune Shard
	[56] = {"56", "0-愚者？", "将角色的所有心(留半心)和掉落物掉在地上#只保留半心#若数量充足, 可作为{{Collectible74}}25美分和{{Collectible19}}轰! 等道具生成"}, -- 0 - The Fool?
	[57] = {"57", "I-魔术师？", "{{Timer}} 获得排斥敌人和弹幕的光环, 持续60秒"}, -- I - The Magician?
	[58] = {"58", "II-女祭司？", "{{Timer}} 妈腿持续尝试践踏角色, 持续60秒"}, -- II - The High Priestess?
	[59] = {"59", "III-皇后？", "{{Timer}} 在60秒内获得:#↑ {{Heart}} +2心之容器#↑ {{Tears}} 射速+1.5#↓ {{Speed}} 移速-0.1"}, -- III - The Empress?
	[60] = {"60", "IV-皇帝？", "传送至额外头目房, 清理后可获得道具#生成的头目来自下一章节"}, -- IV - The Emperor?
	[61] = {"61", "V-教皇？", "{{EmptyBoneHeart}} 生成2骨心"}, -- V - The Hierophant?
	[62] = {"62", "IV-恋人？", "生成当前房间道具池的1个道具#{{BrokenHeart}} 将1心之容器或2魂心转换为1碎心"}, -- VI - The Lovers?
	[63] = {"63", "VII-战车？", "{{Timer}} 在10秒内获得:#↑ {{Tears}} 射速修正x4#无敌, 但不能移动"}, -- VII - The Chariot?
	[64] = {"64", "VIII-正义？", "{{GoldenChest}} 生成2-4个金箱子"}, -- VIII - Justice?
	[65] = {"65", "IX-隐者？", "{{Coin}} 将房间中掉落物和道具转换成其商店价值的硬币#若没有东西转换, 则改为生成1硬币"}, -- IX - The Hermit?
	[66] = {"66", "X-命运之轮？", "{{DiceRoom}} 触发1次随机骰子房效果"}, -- X - Wheel of Fortune?
	[67] = {"67", "XI-力量？", "{{Timer}} 房间中的敌人被{{Slow}}减速, 受到的伤害翻倍, 持续30秒"}, -- XI - Strength?
	[68] = {"68", "XII-倒吊人？", "{{Timer}} 在30秒内获得:#↓ {{Speed}} 移速-0.1#三重泪弹#{{Coin}} 击杀的敌人掉落硬币"}, -- XII - The Hanged Man?
	[69] = {"69", "XIII-死亡？", "{{Collectible545}} 产生亡者之书的效果#{{Friendly}} 即, 当前房间中每击杀1个敌人, 生成1个骨头实体"}, -- XIII - Death?
	[70] = {"70", "XIV-节制？", "{{Pill}} 立即触发5次随机胶囊效果"}, -- XIV - Temperance?
	[71] = {"71", "XV-恶魔？", "#{{Timer}} 在30秒内获得:#{{Collectible390}} 撒拉弗跟班#{{Collectible33}} 圣经的效果:#飞行#{{MomsHeart}} 立即击杀妈腿和妈心#{{Warning}} 当对撒但使用时, 角色会死亡"}, -- XV - The Devil?
	[72] = {"72", "XVI-塔？", "生成7堆随机石头和障碍物#其中经常会有标记石头"}, -- XVI - The Tower?
	[73] = {"73", "XVII-星星？", "移除角色最早收集的1个被动道具(初始道具除外)#生成当前房间道具池的2个道具"}, -- XVII - The Stars?
	[74] = {"74", "XVIII-月亮？", "{{UltraSecretRoom}} 将角色传送至究极隐藏房#返回的路由红色房间构成"}, -- XVIII - The Moon?
	[75] = {"75", "XIX-太阳？", "{{Timer}} 在当前层获得:#↑ {{Damage}} 伤害+1.5#飞行和灵体泪弹#{{BoneHeart}} 心之容器变为骨心(可恢复)#{{CurseDarkness}} 黑暗诅咒"}, -- XIX - The Sun?
	[76] = {"76", "XX-审判？", "{{RestockMachine}} 生成1个补货机"}, -- XX - Judgement?
	[77] = {"77", "XXI-世界？", "{{LadderRoom}} 生成1个暗门"}, -- XXI - The World?
	[78] = {"78", "红钥匙碎片", "{{Collectible580}} 一次性的红钥匙"}, -- Cracked Key
	[79] = {"79", "红桃Q", "{{Heart}} 生成1-20红心"}, -- Queen of Hearts
	[80] = {"80", "万用牌", "复制最近使用过的胶囊/卡牌/符文/魂石/主动道具的效果"}, -- Wild Card
	[81] = {"81", "以撒的魂石", "使房间中所有底座道具在2个道具之间切换"}, -- Soul of Isaac
	[82] = {"82", "抹大拉的魂石", "{{Timer}} 在当前房间中:#{{HalfHeart}} 被击杀的敌人掉落2秒后消失的半红心"}, -- Soul of Magdalene
	[83] = {"83", "该隐的魂石", "打开房间中所有的门#{{Collectible580}} 尽可能在每面墙上创造红色房间"}, -- Soul of Cain
	[84] = {"84", "犹大的魂石", "{{Collectible705}} 激活暗仪刺刀3秒#每击中1个敌人/弹幕, 都有↑ {{Damage}} 暂时伤害提升"}, -- Soul of Judas
	[85] = {"85", "???的魂石", "{{Poison}} 产生8团毒气并留下棕色水迹, 然后快速生成7屁股炸弹#站在水迹中获得:#↑ {{Tears}} 射速+1.5#↑ {{Damage}} 伤害+1"}, -- Soul of ???
	[86] = {"86", "夏娃的魂石", "{{Timer}} 在当前房间中生成14只死鸟跟班追击敌人"}, -- Soul of Eve
	[87] = {"87", "参孙的魂石", "{{Collectible704}} 激活狂怒! 10秒#{{Timer}} 每次击杀使效果延长1秒"}, -- Soul of Samson
	[88] = {"88", "阿撒泻勒的魂石", "{{Collectible441}} 发射超级喷射7.5秒"}, -- Soul of Azazel
	[89] = {"89", "拉撒路的魂石", "角色死亡并立即以半心复活#致死时自动使用此物品(相当于多一条命)"}, -- Soul of Lazarus
	[90] = {"90", "伊甸的魂石", "重置当前房间中的底座道具和掉落物#重置的道具来自随机道具池"}, -- Soul of Eden
	[91] = {"91", "游魂的魂石", "{{Player10}} 在当前房间中, 角色变为游魂#允许免费在{{DevilRoom}}恶魔房拿1个道具#可以免费直接进入陵墓或炼狱"}, -- Soul of the Lost
	[92] = {"92", "莉莉丝的魂石", "永久获得1个随机跟班"}, -- Soul of Lilith
	[93] = {"93", "店主的魂石", "{{Coin}} 生成1-25随机硬币"}, -- Soul of the Keeper
	[94] = {"94", "亚玻伦的魂石", "生成15只随机蝗虫"}, -- Soul of Apollyon
	[95] = {"95", "遗骸的魂石", "{{Player16}} 在当前房间中生成遗骸作为副角色"}, -- Soul of the Forgotten
	[96] = {"96", "伯大尼的魂石", "生成6个随机的{{Collectible584}}美德之书魂火"}, -- Soul of Bethany
	[97] = {"97", "雅各与以扫的魂石", "{{Player20}} 在当前房间中生成以扫作为副角色#以扫含有与角色等量的被动道具"}, -- Soul of Jacob and Esau
}
EID:updateDescriptionsViaTable(repCards, EID.descriptions[languageCode].cards)

-- Card Buffs caused by Tarot Cloth
-- Strings will be appended to the original description (with line breaks replaced with a Tarot Cloth icon)
-- Tables with one entry will completely replace the original description
-- Tables with two or more entries are find-replace pairs (the new text will be colored Shiny Purple)
EID.descriptions[languageCode].tarotClothBuffs = {
	[2] = "同时获得{{Collectible34}}彼列之书的效果", -- I - The Magician
	[3] = "第一只脚落下后不久落下第二只", -- II - The High Priestess
	[4] = {0.3, 0.6, 1.5, 3}, -- III - The Empress
	[5] = "{{SoulHeart}} 如果头目尚未被击败, 传送后+1魂心", -- IV - The Emperor
	[6] = {2, 3}, -- V - The Hierophant
	[7] = {2, 3}, -- VI - The Lovers
	[8] = {6, 12}, -- VII - The Chariot
	[9] = {"生成{{ColorShinyPurple}}2{{CR}}{{UnknownHeart}}随机心, {{ColorShinyPurple}}2{{CR}}{{Coin}}硬币, {{ColorShinyPurple}}2{{CR}}{{Bomb}}炸弹和{{ColorShinyPurple}}2{{CR}}{{Key}}钥匙"}, -- VIII - Justice
	[10] = "阻止贪婪在商店生成#若已与贪婪战斗过, 则将商店变成普通的商店", -- IX - The Hermit
	[11] = {1, 2}, -- X - Wheel of Fortune
	[12] = {1, 2, 0.3, 0.6, 0.3, 0.6, 2.5, 5}, -- XI - Strength
	[14] = {40, 80}, -- XIII - Death
	[15] = {1, 2}, -- XIV - Temperance
	[16] = {2, 3}, -- XV - The Devil
	[17] = {6, 12}, -- XVI - The Tower
	[18] = "若尚未进入过宝箱房, 则生成一组2选1道具", -- XVII - The Stars
	[20] = {100, 400}, -- XIX - The Sun
	[21] = {1, 2}, -- XX - Judgement
	[56] = "除掉落物外, 还掉落角色最近获得的6个道具", -- 0 - The Fool?
	[59] = {2, 3}, -- III - The Empress?
	[61] = {2, 3}, -- V - The Hierophant?
	[62] = "触发效果两次", -- VI - The Lovers?
	[64] = {4, 14, 2, 4}, -- VIII - Justice?
	[65] = "额外生成1{{Coin}}硬币", -- IX - The Hermit?
	[66] = {1, 2}, -- X - Wheel of Fortune?
	[67] = {30, 60}, -- XI - Strength?
	[68] = {30, 60}, -- XII - The Hanged Man?
	[70] = {5, 10}, -- XIV - Temperance?
	[72] = {7, 14}, -- XVI - The Tower?
	[73] = {"移除角色最早收集的{{ColorShinyPurple}}2{{CR}}个被动道具(初始道具除外)#生成当前房间道具池的{{ColorShinyPurple}}4{{CR}}个道具"}, -- XVII - The Stars?
	[76] = {1, 2}, -- XX - Judgement?
}

-- There's some odd behavior with Blank Card + Tarot Cloth not doubling some cards
-- These will be appended after Blank Card recharge time and "Blank Card effect:"
EID.descriptions[languageCode].tarotClothBlankCardBuffs = {
	[11] = "生成1台机器", -- X - Wheel of Fortune
	[12] = "属性加成不翻倍", -- XI - Strength
	[14] = "造成40点伤害", -- XIII - Death
	[15] = "生成1台机器", -- XIV - Temperance
	[16] = "伤害+2", -- XV - The Devil
	[20] = "造成200点伤害", -- XIX - The Sun
	[21] = "生成1个乞丐", -- XX - Judgement
	[56] = "掉落3个道具", -- 0 - The Fool?
	[64] = "生成2-7个箱子", -- VIII - Justice?
	[65] = "不额外生成1硬币", -- IX - The Hermit?
	[66] = "触发效果一次", -- X - Wheel of Fortune?
	[68] = "持续30秒", -- XII - The Hanged Man?
	[72] = "生成7堆", -- XVI - The Tower?
	[73] = "移除1个道具并生成2个", -- XVII - The Stars?
	[76] = "生成1台机器", -- XX - Judgement?
}

---------- Pills ----------

local repPills={
	[4] = {"3", "炸弹变钥匙", "交换角色持有的{{Bomb}}炸弹和{{Key}}钥匙的数量#金炸弹和金钥匙也会交换"}, -- Bombs are Key
	[12] = {"11", "射程下降", "↓ {{Range}} 射程-1"}, -- Range Down
	[13] = {"12", "射程上升", "↑ {{Range}} 射程+1.25"}, -- Range Up
	[38] = {"37", "复古视野", "{{Timer}} 屏幕像素化30秒"},
	[42] = {"41", "好困…", "{{Slow}} 使房间中所有敌人和角色减速"}, -- I'm Drowsy...
	[43] = {"42", "好兴奋！！！", "{{Timer}} 使房间中所有敌人和角色加速#在30秒以及60秒后再触发一次"}, -- I'm Excited!!!
	[48] = {"47", "弹速下降", "↓ {{Shotspeed}} 弹速-0.15"}, -- Shot Speed Down
	[49] = {"48", "弹速上升", "↑ {{Shotspeed}} 弹速+0.15"}, -- Shot Speed Up
	[50] = {"49", "实验性胶囊", "↑ 随机提升1项属性#↓ 随机降低1项属性"}, -- Experimental Pill
	[9999] = {"", "金胶囊", "随机胶囊效果#每次使用后有概率摧毁自身"}, -- Golden Pill
}
EID:updateDescriptionsViaTable(repPills, EID.descriptions[languageCode].pills)

EID.descriptions[languageCode].horsepills={
	{"0", "剧毒臭屁", "{{Poison}} 使房间中所有敌人中毒"}, -- Bad Gas
	{"1", "过激幻觉", "{{Warning}} 对角色造成2心伤害#不多于1心时, 变为体力回满大胶囊(+3魂心)"}, -- Bad Trip
	{"2", "钢铁双蛋", "{{SoulHeart}} +4魂心"}, -- Balls of Steel
	{"3", "炸弹变钥匙", "交换角色持有的{{Bomb}}炸弹和{{Key}}钥匙的数量#炸弹和钥匙各增加50%#金炸弹和金钥匙也会交换"}, -- Bombs are Key
	{"4", "爆炸性腹泻", "生成8个追踪的大炸弹"}, -- Explosive Diarrhea
	{"5", "体力回满", "{{SoulHeart}} +3魂心#{{HealingRed}} 回满血"}, -- Full Health
	{"6", "体力下降", "↓ {{EmptyHeart}} -2心之容器#不多于1心之容器时, 变为体力上升大胶囊"}, -- Health Down
	{"7", "体力上升", "↑ {{EmptyHeart}} +2空心之容器"}, -- Health Up
	{"8", "我找到枚怪药", "无效果"}, -- I Found Pills
	{"9", "青春期", "无效果#吃3个会获得成人套装:#↑ {{Heart}} +1心之容器"}, -- Puberty
	{"10", "漂亮苍蝇", "{{Collectible279}} 获得大粉丝环绕物#角色能拥有的大粉丝数量无限制"}, -- Pretty Fly
	{"11", "射程下降", "↓ {{Range}} 射程-2"}, -- Range Down
	{"12", "射程上升", "↑ {{Range}} 射程+2.5"}, -- Range Up
	{"13", "移速下降", "↓ {{Speed}} 移速-0.24"}, -- Speed Down
	{"14", "移速上升", "↑ {{Speed}} 移速+0.3"}, -- Speed Up
	{"15", "射速下降", "↓ {{Tears}} 射速-0.56"}, -- Tears Down
	{"16", "射速上升", "↑ {{Tears}} 射速+0.7"}, -- Tears Up
	{"17", "运气下降", "↓ {{Luck}} 幸运-2"}, -- Luck Down
	{"18", "运气上升", "↑ {{Luck}} 幸运+2"}, -- Luck Up
	{"19", "传送胶囊", "将角色传送至随机房间"}, -- Telepills
	{"20", "48小时能量！", "{{Battery}} 将主动道具完全充能#{{Battery}} 生成3-4电池"}, -- 48 Hour Energy!
	{"21", "呕血", "{{EmptyHeart}} 清空红心但保留1红心#{{Heart}} 生成4-7红心"}, -- Hematemesis
	{"22", "麻痹", "角色不能移动和发射4秒"}, -- Paralysis
	{"23", "我能永远看清！", "{{SecretRoom}} 打开本层所有隐藏房的入口#揭示全图"}, -- I can see forever!
	{"24", "信息素", "{{Charm}} 将房间中所有敌人永久变成友好的"}, -- Pheromones
	{"25", "失忆症", "{{CurseLost}} 隐藏本层地图"}, -- Amnesia
	{"26", "柠檬派对", "生成满房间的水迹, 对敌人造成伤害"}, -- Lemon Party
	{"27", "你是巫师吗？", "{{Timer}} 角色进行斜角发射60秒"}, -- R U a Wizard?
	{"28", "止痛药！", "{{Timer}} 当前房间中受到的伤害均为半心"},  -- Percs!
	{"29", "上瘾！", "{{Timer}} 当前房间中受到的伤害均为整心"}, -- Addicted!
	{"30", "放-松", "10秒内, 角色在身后生成大便"}, -- Re-Lax
	{"31", "？？？", "{{CurseMaze}} 本层施加混乱诅咒的效果"}, -- ???
	{"32", "变大胶囊", "角色体型变大#不影响命中区域"}, -- One makes you larger
	{"33", "变小胶囊", "角色体型变小#影响命中区域"}, -- One makes you small
	{"34", "大量滋生！", "房间中每1个大便生成2只蓝蜘蛛"}, -- Infested!
	{"35", "大量滋生？", "房间中每有1个敌人生成2只蓝蜘蛛#若房间中没有敌人则生成2-6只蓝蜘蛛"}, -- Infested?
	{"36", "大力丸！", "{{Timer}} 在当前房间中获得:#↑ {{Damage}} 伤害+7#↑ {{Range}} 射程+3#{{Timer}} 在6.5秒内获得:#无敌#角色无法发射, 但每秒造成40点接触伤害#{{HalfHeart}} 每击杀2个敌人治疗半红心#{{Fear}} 使房间中的所有敌人恐惧"}, -- Power Pill!
	{"37", "复古视野", "{{Timer}} 屏幕像素化90秒"}, -- Retro Vision
	{"38", "好朋友一辈子！", "生成12只蓝苍蝇"}, -- Friends Till The End!
	{"39", "泻药", "生成一滩长时间保留的打滑水迹"}, -- X-Lax
	{"40", "哪里不对…", "{{Slow}} 生成一滩长时间保留的减速水迹"}, -- Something's wrong...
	{"41", "好困…", "{{Slow}} 使房间中所有敌人和角色减速"}, -- I'm Drowsy...
	{"42", "好兴奋！！！", "使房间中所有敌人和角色加速#在30秒以及60秒后再触发一次"}, --I'm Excited!!!
	{"43", "咕噜！", "{{Trinket}} 消耗角色的饰品并永久获得其效果#{{HealingRed}} 治疗等同于消耗饰品量的红心"}, -- Gulp!
	{"44", "呕！", "{{Collectible149}} 发射1串吐根泪弹"}, -- Horf!
	{"45", "感觉像漫步在阳光下！", "{{Timer}} 在6.5秒内获得:#无敌#角色无法发射, 但每秒造成40点接触伤害#{{HalfHeart}} 每击杀2个敌人治疗半红心#{{Fear}} 使房间中的所有敌人恐惧"}, -- Feels like I'm walking on sunshine!
	{"46", "嗝！", "生成上次使用的胶囊的大号版本"}, -- Vurp!
	{"47", "弹速下降", "↓ {{Shotspeed}} 弹速-0.3"}, -- Shot Speed Down
	{"48", "弹速上升", "↑ {{Shotspeed}} 弹速+0.3"}, -- Shot Speed Up
	{"49", "实验性胶囊", "↑ 随机提升1项属性2次#↓ 随机降低1项属性2次"}, -- Experimental Pill
	[9999] = {"", "金胶囊", "随机大胶囊效果#每次使用后有概率摧毁自身"}, -- Golden Pill
}

---------- Character Info ----------
local repCharacterInfo = {
	[4] = {"???", "无法拥有红心#{{SoulHeart}} 心之容器改为魂心#{{DevilRoom}} 需要1或2红心的恶魔交易, 改为消耗1或2魂心#摧毁大便生成1只蓝苍蝇"},
	[8] = {"拉撒路", "每层一次, 死亡时:#以复活的拉撒路重生#失去1心之容器#↑ {{Damage}} 伤害+0.5"},
	[11] = {"复活的拉撒路 ", "提升属性, 伤害修正x1.4#进入新层时会变回拉撒路"},
	[12] = {"黑暗犹大 ", "{{Damage}} 伤害修正x2#无法拥有红心#{{BlackHeart}} 体力上升改为获得黑心#{{Player3}} 通关标记为犹大"},
	[14] = {"店主", "{{CoinHeart}} 通过拾起硬币来治疗#最多3硬币心容器#心类掉落物变成蓝苍蝇#{{DevilRoom}} 恶魔交易花费15或30硬币"},
	[18] = {"伯大尼", "{{SoulHeart}} 使用魂心为主动道具充能#无法获得魂心作为血量"},
	[19] = {"雅各", "同时控制雅各和以扫#使用炸弹时, 两个角色都会丢下炸弹#按住{{ButtonRT}}时, 以扫留在原地#{{ButtonLT}}使用雅各的主动道具, {{ButtonRB}}使用以扫的主动道具, 按住{{ButtonRT}}使用他们的卡牌/胶囊#在道具多选一时, 雅各和以扫可以同时拿起道具"},
	[20] = {"以扫", "同时控制雅各和以扫#使用炸弹时, 两个角色都会丢下炸弹#按住{{ButtonRT}}时, 以扫留在原地#{{ButtonLT}}使用雅各的主动道具, {{ButtonRB}}使用以扫的主动道具, 按住{{ButtonRT}}使用他们的卡牌/胶囊#在道具多选一时, 雅各和以扫可以同时拿起道具"},

	[21] = {"堕化以撒", "道具在2个选择之间切换#只能携带8个被动道具#按{{ButtonRT}}切换道具, 以选择被替换的道具"},
	[22] = {"堕化抹大拉", "超过2红心的血量会缓慢流失#接触敌人时进行一次近战攻击, 造成6x角色伤害#{{HalfRedHeart}} 敌人有概率掉落2秒后消失的半红心#近战击杀时必定掉落半红心#{{Collectible45}} 通过非拾取途径获得的治疗效果翻倍#{{AngelDevilChance}} 会流失的红心不影响恶魔房概率"},
	[23] = {"堕化该隐", "接触底座道具会将其变为各种掉落物"},
	[24] = {"堕化犹大", "无法拥有红心#{{BlackHeart}} 心之容器改为黑心"},
	[25] = {"堕化???", "炸弹由大便取代#{{Crafting29}} 造成伤害时生成大便掉落物#{{Collectible715}} 通过使用保留, 存储1个大便以备后用"},
	[26] = {"堕化夏娃", "按住发射键会将你的心转换为血团#不同类型的心会生成拥有不同血量和泪弹效果的血团#血团会随着时间失去血量#按住{{ButtonRT}}时血团会留在原地#只剩半心且没有血团时, 获得治疗或离开房间前, 获得属性提升并使用圣血吸管进行攻击"},
	[27] = {"堕化参孙", "造成或受到伤害会为积攒狂暴状态#{{Timer}} 进入狂暴状态时, 在5秒内:#↑ {{Speed}} 速度+0.4# {{Tears}} 射速修正x0.5#↑ {{Damage}} 伤害+3#攻击变为能反弹子弹的近战攻击#{{Timer}} 每次击杀增加1秒狂暴持续时间并获得短暂无敌"},
	[28] = {"堕化阿撒泻勒", "开始蓄力时咯血#用咯血击中敌人会将蓄力时间减半#咯血造成1.5x角色伤害#{{BrimstoneCurse}} 硫磺火激光对受影响的敌人造成额外伤害#该敌人死亡时会爆炸, 并将诅咒传给附近的敌人"},
	[29] = {"堕化拉撒路", "拉撒路有生死两种状态, 每种状态都有各自的道具和血量#清理房间/波次或使用生死逆转时, 切换到另一种状态"},
	[30] = {"堕化伊甸", "受伤时, 重置角色属性, 道具, 饰品和消耗品#道具会重置成同一道具池中的道具#自伤不会导致重置"},
	[31] = {"堕化游魂", "{{Card51}} 生成的卡牌有10%概率为神圣卡牌#品质{{Quality2}}或以下的道具有20%概率重置#只生成\"攻击性道具\""},
	[32] = {"堕化莉莉丝", "按发射键弹出短距离近战胎儿造成3x伤害#按住发射键保持胎儿在外面, 向最近的敌人发射泪弹"},
	[33] = {"堕化店主", "最多2硬币心容器#敌人会掉落2秒内消失的硬币#大多数底座道具需要15硬币购买#恶魔交易和天使道具需要支付15或30硬币#商店不需要钥匙且商品增加"},
	[34] = {"堕化亚伯伦", ""},
	[35] = {"堕化遗骸", "遗骸是一堆不能移动的骨头, 由遗骸之魂拾起并投掷, 造成3x伤害#只有遗骸之魂会受到伤害#炸弹会放置在遗骸的位置#无法拥有红心#{{SoulHeart}} 心之容器改为魂心"},
	[36] = {"堕落伯大尼", "{{Heart}} 使用红心为主动道具充能#无法拥有红心#{{SoulHeart}} 心之容器改为魂心和红心充能#属性提升只有75%效力"},
	[37] = {"堕落雅各", "堕化以扫会追击堕化雅各, 接近时冲刺#冲刺会对敌人造成大量伤害#若击中堕化雅各, 堕化雅各在本层后续会变为灵魂, 受伤即死#作为灵魂时, 每房间可以免费进行一次恶魔交易"},
	[38] = {"死去的堕化拉撒路", "拉撒路有生死两种状态, 每种状态都有各自的道具和血量#清理房间/波次或使用生死逆转时, 切换到另一种状态"},
	[39] = {"堕化雅各之魂", "#飞行#灵体泪弹#{{Warning}} 受伤即死#{{Warning}} 被堕化以扫击中时死亡#{{DevilRoom}} 每房间可以免费进行一次恶魔交易#下一层时变回堕化雅各"},
	[40] = {"堕化遗骸之魂", "遗骸是一堆不能移动的骨头, 由遗骸之魂拾起并投掷, 造成3x伤害#只有遗骸之魂会受到伤害#炸弹会放置在遗骸的位置#无法拥有红心#{{SoulHeart}} 心之容器改为魂心"},
}
EID:updateDescriptionsViaTable(repCharacterInfo, EID.descriptions[languageCode].CharacterInfo)

EID.descriptions[languageCode].birthright ={
	{"以撒", "", "所有道具在2个选择间切换"},
	{"抹大拉", "", "↑ {{Heart}} +1心之容器#心上限提高到18"},
	{"该隐", "", "↑ {{Luck}} 幸运+1#{{ArcadeRoom}} 后续所有层都含有一个升级的游戏厅(暗室, 玩具箱除外)#{{Collectible46}} 极大增强幸运脚的获胜概率提高的效果"},
	{"犹大", "", "{{Collectible34}} 彼列之书变成类似于{{Collectible584}}美德之书的被动道具#{{Collectible34}} 若当前未持有则获得彼列之书#↑ {{Damage}} 获得的伤害加成与在其上的主动道具充能量成比例#某些主动道具会获得特殊效果"},
	{"???", "", "{{SoulHeart}} 体力上升获得的魂心翻倍"},
	{"夏娃", "", "{{Collectible122}} 巴比伦大淫妇和死鸟始终激活"},
	{"参孙", "", "{{Collectible157}} 嗜血每层可额外再触发4次, 触发10次至最大+14伤害"},
	{"阿撒泻勒", "", "阿撒泻勒的硫磺火变得更宽#伤害不提升"},
	{"拉撒路", "", "↑ 复活的拉撒路{{Damage}}伤害+7.2#{{Timer}} 获得的伤害在60秒内衰减#{{Blank}} 效果尚存时击杀敌人会延长时间"},
	{"伊甸", "", "从随机道具池生成3个随机道具#只能拿1个"},
	{"游魂", "", "阻止对游魂无好处的道具生成#比如: 回血, 飞行, 灵体泪弹, 受伤触发的道具"},
	{"复活的拉撒路", "", "↑ {{Damage}} 伤害+7.2#{{Timer}} 获得的伤害在60秒内衰减#{{Blank}} 效果尚存时击杀敌人会延长时间"},
	{"黑暗犹大", "", "{{Collectible34}} 彼列之书变成类似于{{Collectible584}}美德之书的被动道具#{{Collectible34}} 若当前未持有则获得彼列之书#↑ {{Damage}} 获得的伤害加成与在其上的主动道具充能量成比例#某些主动道具会获得特殊效果"},
	{"莉莉丝", "", "跟班在莉莉丝面前位置"},
	{"店主", "", "↑ {{CoinHeart}} +1硬币心容器#硬币心容器上限为4"},
	{"亚玻伦", "", "{{Collectible477}} 使用虚空时有概率生成之前被虚空吸收的道具#属性加成仍保留#吸收的道具越多, 生成道具的概率越高"},
	{"遗骸", "", "遗骸之魂不再绑定, 可自由移动"},
	{"遗骸之魂", "", "遗骸之魂不再绑定, 可自由移动"},
	{"伯大尼", "", "{{Battery}} 使用魂心充能激活道具时, 50%概率不消耗魂心充能"},
	{"雅各", "", "拿起这个道具的角色获得另个角色3个被动道具的复制品"},
	{"以扫", "", "拿起这个道具的角色获得另个角色3个被动道具的复制品"},
	{"堕化以撒", "", "增加4个额外被动道具槽位#长子名分本身不占用槽位"},
	{"堕化抹大拉", "", "{{Heart}} 不流失的心之容器增加1个#{{HealingRed}} 治疗1红心"},
	{"堕化该隐", "", "道具分解生成的掉落物数量翻倍"},
	{"堕化犹大", "", "{{Collectible705}} 暗仪刺刀击中敌人和弹幕的范围变大"},
	{"堕化???", "", "{{PoopPickup}} 增加大便最大携带量为29"},
	{"堕化夏娃", "", "{{HalfHeart}} 死亡的红心血团生成2秒后消失的半红心"},
	{"堕化参孙", "", "{{Collectible704}} 击杀敌人时狂暴计时增加3秒而不是1秒"},
	{"堕化阿撒泻勒", "", "{{Collectible726}} 咯血症攻击大小翻倍"},
	{"堕化拉撒路", "", "未激活的形态作为虚角色#虚角色无敌, 造成0.25x伤害#两个角色都有长子名分的效果"},
	{"堕化伊甸", "", "在长子名分之前拿到的道具不会被重置#主动道具放下又拾起后可再次被重置"},
	{"堕化游魂", "", "获得1额外生命#死亡时, 在相同房间中重生并对附近敌人造成200点伤害"},
	{"堕化莉莉丝", "", "{{Collectible728}} 正常跟随的跟班改为与格罗行为一致#每有1个跟班, 造成的近战伤害+3"},
	{"堕化店主", "", "{{Coin}} 强力吸引击杀敌人掉落的硬币#对其他硬币无效果"},
	{"堕化亚玻伦", "", "按住发射键使蝗虫持续对敌人造成伤害而不返回"},
	{"堕化遗骸", "", "{{Collectible714}} 堕化遗骸之魂获得召回能力, 从任意距离召回堕化遗骸#遗骸之魂在遗骸返回时无敌"},
	{"堕化伯大尼", "", "生成4个品质{{Quality3}}和{{Quality4}}的随机道具魂火, 血量比正常魂火高很多"},
	{"堕化雅各", "", "堕化以扫分裂为两个#两者会同时冲刺#{{Collectible722}} 孤魂铁索的冷却降至10秒#{{Chained}} 使用孤魂铁索禁锢两者6.67秒"},
	{"死亡的堕化拉撒路", "", "未激活的形态作为虚角色#虚角色无敌, 造成0.25x伤害#两个角色都有长子名分的效果"},
	{"堕化雅各之魂", "", "堕化以扫分裂为两个#两者会同时冲刺#{{Collectible722}} 孤魂铁索的冷却降至10秒#{{Chained}} 使用孤魂铁索禁锢两者6.67秒"},
	{"堕化遗骸之魂", "", "{{Collectible714}} 堕化遗骸之魂获得召回能力, 从任意距离召回堕化遗骸#遗骸之魂在遗骸返回时无敌"},
}

---------- Glitched Item Descriptions ----------

EID.descriptions[languageCode].GlitchedItemText = {
	-- Item Config info
	-- These texts are affected by the PluralizeFunction (ab+ file)
	AddBlackHearts = "{{BlackHeart}} {1}黑心",
	AddBombs = "{{Bomb}} {1}炸弹",
	AddCoins = "{{Coin}} {1}硬币",
	AddHearts = "{{HealingRed}} 治疗{1}红心",
	AddKeys = "{{Key}} {1}钥匙",
	AddMaxHearts = "{{EmptyHeart}} {1}心之容器",
	AddSoulHearts = "{{SoulHeart}} {1}魂心",

	-- Cache Flag names
	cacheFlagStart = "可能影响",
	[0] = "{{Damage}} 伤害", "{{Tears}} 射速", "{{Shotspeed}} 弹速", "{{Range}} 射程", "{{Speed}} 移速", "泪弹效果", "泪弹颜色", "飞行", "攻击类型", "跟班", "{{Luck}} 幸运", "体型", "颜色", "箱子内容物", [16] = "所有属性",

	-- Attribute triggers
	active = "使用时:#",
	pickup_collected = "收集1掉落物时:#",
	enemy_kill = "击杀敌人时, 20%概率:#",
	damage_taken = "受伤时:#",
	entity_spawned = "当{T1}生成时:#",
	tear_fire = "发射泪弹时, 5%概率:#",
	enemy_hit = "击中敌人时, 5%概率:#",
	room_clear = "清理房间后:#",
	chain = "然后:{{CR}} ",

	-- Attribute effects
	area_damage = "在角色周围{2}格内造成{1}点伤害",
	add_temporary_effect = "在当前房间中获得{1}",
	convert_entities = "将当前房间中所有{1}变为{2}",
	use_active_item = "使用{1}",
	spawn_entity = "生成1个{1}",
	fart = "在角色周围{1}格内放屁",

	-- Generic entity names not obtained from entities2.xml
	-- This could also be a place to localize entity names; this table is read from before EID.XMLEntityNames
	["4.-1"] = "激活的炸弹",
	["5.0"] = "掉落物",
	["5.10"] = "心",
	["5.20"] = "硬币",
	["5.30"] = "钥匙",
	["5.40"] = "炸弹掉落物",
	["5.69"] = "福袋",
	["5.70"] = "胶囊",
	["5.90"] = "电池",
	["5.300"] = "卡牌",
	["5.301"] = "符文", -- not a real ID
	["9.-1"] = "敌人弹幕",
	["999.-1"] = "障碍物",
	["1000.0"] = "效果",

	-- Text for the base item that is granted
	grants = "获得",
}

---------- Bag of Crafting Text ----------
EID.descriptions[languageCode].CraftingBagContent = "宝袋中:"
EID.descriptions[languageCode].CraftingRoomContent = "房间中:"
EID.descriptions[languageCode].CraftingFloorContent = "当前层:"
EID.descriptions[languageCode].CraftingSearch = "搜索:"
EID.descriptions[languageCode].CraftingBagQuality = "袋中品质:"
EID.descriptions[languageCode].CraftingBestQuality = "最佳品质:"
EID.descriptions[languageCode].CraftingHideKey = "隐藏:"
EID.descriptions[languageCode].CraftingPreviewKey = "预览:"
-- {1} will be converted to the number of recipes
EID.descriptions[languageCode].CraftingMore = "...还有{1}个"
-- {1} will be converted into the number of available items
EID.descriptions[languageCode].CraftingNumAvailableItems = "8个道具中有{1}个可用"
EID.descriptions[languageCode].CraftingWarningAvailableItems = "需要至少8个才能显示合成配方!"
-- {1} will be converted into the name of the key that toggles the BoC visibility
EID.descriptions[languageCode].CraftingIsHidden = "当前已隐藏(按{1}解除隐藏)"
-- {1} will be converted into the name of the key that toggles the BoC Search
EID.descriptions[languageCode].CraftingResults = "(滚动: 按住{{CONFIG_BoC_Toggle}}+{{ButtonY}} {{ButtonA}}, 锁定: {{ButtonX}}, 刷新: {{ButtonB}}, 重置宝袋: 按住{{ButtonRB}}, 搜索: {1})"

-- Strings for Tainted Cain's pedestal salvaging; the non-base lines will have the corresponding icon automatically
EID.descriptions[languageCode].TaintedCainPedestalBase = "接触时变为3-8随机掉落物"
EID.descriptions[languageCode].TaintedCainPedestalBaseBirthright = "接触时变为{{BlinkBirthright}}6-16{{CR}}随机掉落物"
EID.descriptions[languageCode].TaintedCainPedestalGuaranteed = "必定生成1{1}" -- Room type spawns
EID.descriptions[languageCode].TaintedCainPedestalBonus = "33%概率1额外{1}" -- "Safety Cap" type spawns
EID.descriptions[languageCode].TaintedCainPedestalLuckyToe = "66%概率1额外掉落物"
EID.descriptions[languageCode].TaintedCainPedestalLuckyToeBirthright = "66%概率{{BlinkBirthright}}2{{CR}}额外掉落物"
EID.descriptions[languageCode].TaintedCainPedestalDaemonsTail = "心类掉落物概率降低80%"


---------- Misc. Text ----------

EID.descriptions[languageCode].ResultsWithX = "({1}的结果)"
EID.descriptions[languageCode].VariableCharge = "{1}充能:"

EID.descriptions[languageCode].poopSpells = {
	{"大便", "可生成掉落物的普通大便"},
	{"玉米大便", "完整时生成蓝苍蝇"},
	{"燃烧大便", "完整时造成接触伤害#被摧毁时留下火焰"},
	{"岩石大便", "投掷时可造成3次解除伤害#需要受击更多次才能摧毁"},
	{"恶臭大便", "释放毒气#{{Warning}} 毒气接触火会爆炸!"},
	{"黑大便", "{{Slow}} 产生减速水迹#{{Confusion}} 被摧毁时对所有敌人造成10点伤害并使其混乱"},
	{"神圣大便", "{{Collectible543}} 产生1个白大便#在光环中时:#↑ {{Damage}} 伤害修正x1.2#↑ {{Tears}} 射速修正x2.5#追踪泪弹#50%概率阻挡伤害#"},
	{"棕色水迹", "留下水迹#对敌人造成接触伤害#角色站在水迹上会提升射速和伤害#当轨迹与其他大便接触时, 获得特殊效果"},
	{"屁", "推开周围的敌人和弹幕, 生成毒气#{{Warning}} 毒气接触火会爆炸!"},
	{"大便炸弹", "普通的可投掷炸弹"},
	{"爆炸性腹泻", "在角色位置生成5个激活的炸弹"},

	--Undetected poop, for Poop API
	--[Poop name in code] = {Icon, Name, Description}
	["Unknown"] = {"{{PoopSpell1}}", "未知大便", "大便的效果未知"}
}

EID.descriptions[languageCode].itemPoolFor = "道具池:"
EID.descriptions[languageCode].itemPoolNames = {
	[0] = "宝箱房", "商店", "头目房", "恶魔房", "天使房", "隐藏房", "图书馆", "赌博乞丐", "金箱子", "红箱子", "乞丐", "恶魔乞丐", "诅咒房", "钥匙大师", "电池乞丐", "妈妈的箱子", "贪婪宝箱房", "贪婪头目房", "贪婪商店", "贪婪恶魔房", "贪婪天使房", "贪婪诅咒房", "贪婪隐藏房", "娃娃机", "究极隐藏房", "炸弹乞丐", "星象房", "旧箱子", "宝宝商店", "木箱子", "腐烂乞丐",
}

EID.descriptions[languageCode].VoidShopText = "若在举起道具时吸收, 则获得:"
EID.descriptions[languageCode].VoidOptionText = "将被吸收"
EID.descriptions[languageCode].VoidNames[2] = "{1}射速"

EID.descriptions[languageCode].PurityBoosts = {[0] = "↑ {{Damage}} 伤害+4", "↑ {{Tears}} 射速+2", "↑ {{Speed}} 移速+0.5", "↑ {{Range}} 射程+3"}

EID.descriptions[languageCode].spindownError = "道具消失"

EID.descriptions[languageCode].BlankCardEffect = "空白卡牌效果:"

EID.descriptions[languageCode].FlipItemToggleInfo = "(按住{{CONFIG_BoC_Toggle}}以显示描述)"
EID.descriptions[languageCode].GlitchedCrownToggleInfo = "(按{{CONFIG_BoC_Toggle}}以显示下一个描述: {1})"

EID.descriptions[languageCode].GlowingHourglassTransformed = "下一层会变回发光沙漏"

EID.descriptions[languageCode].FalsePHDHeart = "生成1{{BlackHeart}}黑心"
EID.descriptions[languageCode].FalsePHDDamage = "↑ {{Damage}} 伤害+0.6"
EID.descriptions[languageCode].FalsePHDHorseDamage = "↑ {{Damage}} 伤害+1.2"

EID.descriptions[languageCode].ExperimentalPillPHD = "不降低属性"
EID.descriptions[languageCode].ExperimentalPillFalsePHD = "不提升随机属性"

EID.descriptions[languageCode].PandorasBoxStrangeKeyEffect = "改为消耗钥匙并生成6个随机道具池的道具"

EID.descriptions[languageCode].AchievementWarningTitle = "{{ColorYellow}}{{Warning}} 警告 {{Warning}}"
EID.descriptions[languageCode].AchievementWarningText = "成就已禁用!#为启用进度和成就, 你需要在不启用模组的情况下击败妈妈(深牢II)一次#(若已击败过, 这条信息是bug可以忽视)#(这条警告可以在设置中禁用)"
EID.descriptions[languageCode].OldGameVersionWarningText = "EID已更新至最新Steam版本#你的游戏版本不受官方支持, 因此一些描述和功能会不准确#(这条警告可以在设置中禁用)"
EID.descriptions[languageCode].ModdedRecipesWarningText = "其他模组的道具可能会使合成配方计算不准确!#安装忏悔龙(REPENTOGON)以改善模组配方支持#(这条警告可以在设置中禁用)"


-- Conditional descriptions - DO NOT TRANSLATE THE FIRST PART IN ["BRACKETS"]
-- Strings will be appended to the original description
-- Tables with one entry will completely replace the original description
-- Tables with two or more entries are find-replace pairs (if there's an odd number of entries, the last entry is appended)
-- For collectible/player conditionals, lines will automatically have their bulletpoint, and {1} is replaced with their name
local repConditions = {
	------ GENERAL STRINGS ------
	["Tainted Revive"] = "{1}只是复活",
	["Ice Tears"] = "冻结敌人不算击杀", -- Uranus Anti-Synergy

	------ GREED MODE ------
	["5.100.344"] = {"{{BlackHeart}} +1黑心#{{Bomb}} 生成3炸弹"}, -- Match Book (Greed)
	["5.300.74"] = {"将角色传送至本层初始房间"}, -- The Moon? (Greed)
	["5.100.416"] = {"{{Coin}} 提高硬币上限至999"}, -- Deep Pockets (Greed)
	["5.100.566"] = {"{{HalfSoulHeart}} 进入新层时+1半魂心#!!! 贪婪模式中, 每层过场噩梦中显示的宝箱房道具是错的"}, -- Dream Catcher (Greed)
	["5.100.580"] = "{{GreedMode}} 贪婪模式中仅能产生少见的特殊房间#{{SuperSecretRoom}} 仍能帮助寻找超级隐藏房", -- Red Key (Greed)
	["5.300.83"] = "{{GreedMode}} 贪婪模式中仅能产生少见的特殊房间#{{SuperSecretRoom}} 仍能帮助寻找超级隐藏房", -- Soul of Cain (Greed)
	["5.100.514"] = {"随机间隔使一些敌人和弹幕短暂停滞#暂停的弹幕消失"}, -- Broken Modem (Greed)
	["5.350.162"] = {"{{Player7}} 清理房间后有50%概率变为阿撒泻勒#{{Timer}} 效果持续到清理另一个波次"}, -- Azazel's Stump (Greed)


	------ ACHIEVEMENT CHECKS ------
	-- todo...


	------ SPECIFIC CHARACTER SYNERGIES/CHANGES ------
	["5.100.642"] = {"!!! 一次性 !!!#生成当前房间道具池的1个道具"}, -- Magic Skin + Lost
	["5.100.240"] = "{1}: 在扔下后保留属性变化", -- Experimental Treatment + Tainted Isaac
	["5.100.644"] = "{1}: 在扔下后保留属性提升", -- Consolation Prize + Tainted Isaac
	["5.100.549"] = {"↑ {{Tears}} 射速+0.4"}, -- Brittle Bones (Keeper+Lost)
	["5.100.694"] = "对{1}有效, 使其能多承受4次伤害", -- Heartbreak + Losts
	["5.100.694 (Keeper)"] = {"↑ {{Damage}} 每个碎心使伤害+0.25#{{BrokenHeart}} +1碎心#{{BrokenHeart}} 致死时, 致死伤害改为+1碎心#{{Warning}} 店主3碎心时死亡"}, -- Heartbreak + Normal Keeper
	["5.100.694 (Tainted Keeper)"] = {"{{Warning}} {1}拾起此道具后受伤即死#↑ {{Damage}} 每个碎心使伤害+0.25#{{BrokenHeart}} +1碎心#{{BrokenHeart}} 致死时, 致死伤害改为+1碎心#{{Warning}} 堕化店主2碎心时死亡"}, -- Heartbreak + Tainted Keeper
	["5.100.501"] = "{1}: 获得额外的硬币心容器", -- Greed's Gullet + Keeper
	["5.100.188"] = "{1}: 造成7.5点伤害", -- Cain + Abel
	["5.100.360"] = "{1}: 造成1x角色伤害", -- Lilith + Incubus
	["5.100.728"] = "{1}: 造成1x角色伤害", -- Lilith + Gello
	["5.100.230 (Keeper)"] = "{1}: 保留1硬币心容器", -- Abaddon
	["5.100.230 (Bethany)"] = "{1}: 保留半红心", -- Abaddon
	["5.100.230 (Tainted Bethany)"] = "{1}: 不失去红心充能", -- Abaddon
	["5.100.245 (Keeper)"] = {"↑ {{Tears}} 提升射速#↑ 降低泪弹分布#↓ {{Damage}} 伤害修正x0.8"}, -- 20/20 + Keeper
	["5.100.205 (Tainted Magdalene)"] = "允许无限使用美味的心", -- Sharp Plug + Tainted Magdalene

	["5.100.705"] = "每个弹幕/敌人使伤害暂时+1", -- Dark Arts + Dark/Tainted Judas
	["5.100.722"] = {"{{Chained}} 禁锢堕化以扫#5秒后或再次使用后, 以扫自由并追击雅各"}, -- TJacob + Anima Sola
	["5.100.713"] = {"将所有血团召回夏娃的血条中#溢出的血团只移动到角色位置#{{Timer}} 1秒充能"}, --Teve + Sumptorium
	["5.100.711"] = {"进入", "{{Player38}} 逆转拉撒路为另一个状态#进入"}, -- Tlaz + Flip
	["5.100.710"] = {"使用后, 向发射方向用袋挥击#击中的掉落物放入袋中#装满时, 按{{ButtonRT}}切换袋中掉落物位置#装满时, 按住使用键合成预览的道具#道具品质由掉落物品质决定"}, -- Tcain Bag of Crafting

	["Mother's Kiss Soul"] = {"{{SoulHeart}} 持有时+1魂心"},
	["Mother's Kiss Bone"] = {"{{BoneHeart}} 持有时+1骨心"},
	["Mother's Kiss Coin"] = {"{{CoinHeart}} 持有时+1硬币心容器#硬币心容器上限提升1"},

	-- Vibrant/Dim Bulb
	["5.350.100 (Bethany)"] = "对{1}的魂心充能有效",
	["5.350.100 (Tainted Bethany)"] = "对{1}的红心充能有效",
	["5.350.101 (Bethany)"] = "忽略{1}的魂心充能",
	["5.350.101 (Tainted Bethany)"] = "忽略{1}的红心充能",
	["Health Up Soul Charges"] = "+{1}魂心充能",
	["Health Up Blood Charges"] = "+{1}红心充能",

	-- Tainted Bethany stuff
	["2 of Hearts Blood Charges"] = "使{1}的红心充能翻倍",
	["Vampire Blood Charges"] = {"↑ {{Damage}} 伤害+0.3#每击杀13个敌人增加1红心充能"},
	["Fork Blood Charges"] = {"清理房间后, 10%概率增加1红心充能"},
	["Stem Cell Blood Charges"] = {"进入新层时, 增加1红心充能"},

	["Salvaging Bonus"] = {"炸毁的机器", "炸毁的机器, 分解的道具"},
	["Salvaging Lucky Toe"] = "66%概率分解道具额外产生1掉落物",


	------ DUPLICATE COPIES OF ITEMS ------
	["5.100.2 (Copies)"] = "角色再多发射1颗泪弹#没有额外属性降低", -- The Inner Eye
	["5.100.153 (Copies)"] = "角色再多发射2颗泪弹#没有额外属性降低", -- Mutant Spider
	["5.100.245 (Copies)"] = "角色再多发射1颗泪弹#没有额外属性降低", -- 20/20
	["5.100.358 (Copies)"] = "角色再多发射1颗更靠近中心的泪弹", -- The Wiz
	["5.100.64 (Copies)"] = "持有多个此道具可以进一步降低价格", -- Steam Sale
	["5.100.118 (Copies)"] = "多个硫磺火可使伤害和宽度更大", -- Brimstone
	["5.100.531 (Copies)"] = "额外重复品仅有伤害+1的效果", -- Haemolacria
	["5.100.224 (Copies)"] = "额外重复品仅有射速+0.5的效果", -- Cricket's Body


	----- MISC. ITEM CONDITIONS ------
	["Sacrificial Nugget"] = "将苍蝇炮塔变为硬币",
	["Sacrificial Item Wisps"] = "所罗门魔典产生的跟班可以被献祭#将所有所罗门魔典魂火变为{{HalfSoulHeart}}半魂心",
	["Sacrificial Plum"] = "召唤的糖梅宝宝算作跟班, 不会移除糖梅溜溜笛",
	["Sacrificial Quints"] = "若1个五胞胎跟班被献祭, 则会失去五胞胎道具",
	["Sacrificial Abyss"] = "无底坑蝗虫算作跟班",
	["Sacrificial Star"] = "伯列恒之星算作跟班",
	["Sacrificial Clots"] = "将血团变为硬币",

	["1000.76.1"] = "{{Warning}} 只重置激活此效果的角色的道具", -- Dice Room 1 (Co-op)
	["1000.76.6"] = "{{Warning}} 合作中, 所有角色的道具都会被重置!", -- Dice Room 6 (Co-op)
	["5.100.45"] = "治疗其他玩家半红心", -- Yum Heart (Co-Op)
	["5.350.125"] = "角色之间也有电束", -- Extension Cord (Co-Op)

	["5.100.245"] = "移除{1}的射速惩罚", -- 20/20 + Mutant Spider, The Inner Eye, Polyphemus
	["20/20"] = "持有{1}时没有射速惩罚", -- 20/20 + Mutant Spider, The Inner Eye, Polyphemus

	["5.100.135 (Hard Mode)"] = {"1-2", "1", "2-3", "2"}, -- IV Bag Hard Mode (modify the PHD text too)
	["5.100.201"] = "拾起时, 补充{1}的充能", -- Iron Bar + Notched Axe
	["5.350.172"] = "{1}可移除传送效果", -- Cursed Penny + Black Candle
	["5.100.501 (Deep Pockets)"] = "超过99硬币后, 每100硬币+1心之容器", -- Greed's Gullet + Deep Pockets
	["? Card Single Use"] = "一次性道具可以用?卡多次使用", -- Single Use Actives + ? Card
	["Both Peppers"] = "持有{1}时, 发射火焰的基础概率为12.5%, 幸运7时达到100%", -- Ghost Pepper + Bird's Eye
	["Black Feather"] = "↑ {{Damage}} 伤害+0.5", -- Black Feather items
	["Hemoptysis"] = "{1}有效", -- Hemoptysis + Brimstone items
	["5.100.600"] = "{1}: 改为射速修正x1.2", -- Eye Drops (items and some players)
	["5.100.482"] = "堕化角色换为另一个堕化角色", -- Clicker

	["4.5 Volt Timed"] = "对时间充能无效", -- 4.5 Volt + Timed Recharges
	["4.5 Volt Multiple"] = "副主动/次要主动道具只有在主要主动道具完全充能时获得充能", -- 4.5 Volt + Schoolbag/Pocket Actives
	["Bulb Zero"] = "零充能的主动道具不算", -- Vibrant/Dim Bulb + zero charge actives

	["Brimstone Proptosis"] = "激光在最近时造成6x伤害, 伤害随距离降低",
	["Brimstone Ipecac"] = "激光伤害+2, 在敌人和障碍物上爆炸",
	["Brimstone Pop!"] = "更短的激光, 在末端发射{1}泪弹",
	["Eye of Belial Dr. Fetus"] = "炸弹穿透, 造成2.5x伤害, 但不追踪也没有额外爆炸伤害",
	["Spirit Sword C Section"] = "{1}优先#胎儿持有剑并旋转攻击",
	["Spirit Sword Mom's Knife"] = "{1}优先#旋转攻击会将剑向前投掷",
	["Spirit Sword Technology"] = "剑变成可以反弹敌人弹幕的光剑",
	["Spirit Sword Ipecac"] = "剑伤害+6并有毒, 但不会爆炸#剑气造成爆炸",
	["Ludovico Ipecac"] = "泪弹伤害+2, 但不会爆炸或中毒",
	["Technology Ipecac"] = "激光伤害+2, 并在目标上爆炸",
	["Eye of the Occult Beam"] = "角色自动向更改光柱路径的准星发射",

	["Lullaby Clots"] = "(包括血团)",
	["Lullaby Incubus"] = "(包括淫魔)",

	-- Jacob's Ladder / 120 Volt battery synergies
	["Sparks Damage"] = "电弧造成的伤害+50%",
	["Sparks Arc Length"] = "电弧距离更长",
	["Sparks Arc Count"] = "电弧再多电穿2个敌人",
	["Sparks Arc Back"] = "电弧可穿回相同敌人",

	["White Poop Jar"] = "1充能使用时生成白大便",
	["Golden Poop Jar"] = "1充能使用时有概率生成金大便",

	["Binge Eater Healing"] = {"治疗1红心", "治疗{{BlinkGreen}}2{{CR}}红心", "+4红心充能", "+{{BlinkGreen}}6{{CR}}红心充能"},
}
EID:updateDescriptionsViaTable(repConditions, EID.descriptions[languageCode].ConditionalDescs)




-- If Debug enabled, add overwrite tables to the languagepack in order for the language completion script to be able to compare them
if EID.enableDebug then
	EID.descriptions[languageCode].repCollectibles = repCollectibles
	EID.descriptions[languageCode].repTrinkets = repTrinkets
	EID.descriptions[languageCode].repCards = repCards
	EID.descriptions[languageCode].repPills = repPills
end

if REPENTOGON then
	EID.descriptions[languageCode].custom["6.8.0"] = {"0", "捐款机", "下个成就在{1}硬币, 还需{2}硬币#{{Luck}} 捐款时, 2%概率幸运+1#{{AngelRoom}} 捐10硬币可提升天使房概率"}
	EID.descriptions[languageCode].custom["6.11.0"] = {"0", "贪婪捐款机", "下个成就在{1}硬币, 还需{2}硬币"}
end
